/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.app;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.AsyncTaskLoader;
import androidx.loader.content.Loader;
import androidx.transition.TransitionManager;
import com.genonbeta.android.framework.R;
import com.genonbeta.android.framework.app.Fragment;
import com.genonbeta.android.framework.app.ListFragmentBase;
import com.genonbeta.android.framework.widget.ListAdapterBase;
import java.util.List;

public abstract class ListFragment<Z extends ViewGroup, T, E extends ListAdapterBase<T>>
extends Fragment
implements ListFragmentBase<T> {
    public static final String TAG = ListFragment.class.getSimpleName();
    public static final int LAYOUT_DEFAULT_EMPTY_LIST_VIEW = R.layout.genfw_layout_listfragment_emptyview;
    public static final int TASK_ID_REFRESH = 0;
    private E mAdapter;
    private Z mListView;
    private ViewGroup mEmptyListContainerView;
    private TextView mEmptyListTextView;
    private ImageView mEmptyListImageView;
    private ProgressBar mProgressBar;
    private Button mEmptyListActionButton;
    private RefreshLoaderCallback mRefreshLoaderCallback = new RefreshLoaderCallback();

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.findViewDefaultsFromMainView();
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        LoaderManager.getInstance((LifecycleOwner)this).initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mRefreshLoaderCallback);
    }

    protected void onPrepareRefreshingList() {
    }

    protected void onListRefreshed() {
    }

    public AsyncTaskLoader<List<T>> createLoader() {
        return new ListLoader(this.mAdapter);
    }

    protected abstract void ensureList();

    protected void findViewDefaultsFrom(View view) {
        if (view == null) {
            return;
        }
        this.setListView((ViewGroup)view.findViewById(R.id.genfw_customListFragment_listView));
        this.setEmptyListContainerView((ViewGroup)view.findViewById(R.id.genfw_customListFragment_emptyView));
        this.setEmptyListTextView((TextView)view.findViewById(R.id.genfw_customListFragment_emptyTextView));
        this.setEmptyListImageView((ImageView)view.findViewById(R.id.genfw_customListFragment_emptyImageView));
        this.setEmptyListActionButton((Button)view.findViewById(R.id.genfw_customListFragment_emptyActionButton));
        this.setProgressBar((ProgressBar)view.findViewById(R.id.genfw_customListFragment_progressBar));
    }

    protected void findViewDefaultsFromMainView() {
        this.findViewDefaultsFrom(this.getView());
    }

    public E getAdapter() {
        return this.mAdapter;
    }

    protected abstract View generateDefaultView(LayoutInflater var1, ViewGroup var2, Bundle var3);

    public ViewGroup getEmptyListContainerView() {
        this.ensureList();
        return this.mEmptyListContainerView;
    }

    public ImageView getEmptyListImageView() {
        this.ensureList();
        return this.mEmptyListImageView;
    }

    public TextView getEmptyListTextView() {
        this.ensureList();
        return this.mEmptyListTextView;
    }

    public Button getEmptyListActionButton() {
        this.ensureList();
        return this.mEmptyListActionButton;
    }

    public E getListAdapter() {
        return this.mAdapter;
    }

    protected final Z getListViewInternal() {
        return this.mListView;
    }

    public Z getListView() {
        this.ensureList();
        return this.getListViewInternal();
    }

    public RefreshLoaderCallback getLoaderCallbackRefresh() {
        return this.mRefreshLoaderCallback;
    }

    public ProgressBar getProgressBar() {
        this.ensureList();
        return this.mProgressBar;
    }

    @Override
    public void refreshList() {
        this.getLoaderCallbackRefresh().requestRefresh();
    }

    protected void setEmptyListContainerView(ViewGroup container) {
        this.mEmptyListContainerView = container;
    }

    protected void setEmptyListActionButton(Button button) {
        this.mEmptyListActionButton = button;
    }

    protected void setEmptyListImage(int resId) {
        this.getEmptyListImageView().setImageResource(resId);
    }

    protected void setEmptyListImageView(ImageView view) {
        this.mEmptyListImageView = view;
    }

    protected void setEmptyListText(CharSequence text) {
        this.getEmptyListTextView().setText(text);
    }

    protected void setEmptyListTextView(TextView view) {
        this.mEmptyListTextView = view;
    }

    protected void setListAdapter(E adapter) {
        boolean hadAdapter = this.mAdapter != null;
        this.mAdapter = adapter;
        this.setListAdapter(adapter, hadAdapter);
    }

    protected abstract void setListAdapter(E var1, boolean var2);

    public void setListLoading(boolean loading) {
        this.setListLoading(loading, true);
    }

    public void setListLoading(boolean loading, boolean animate) {
        this.ensureList();
        ProgressBar progressBar = this.getProgressBar();
        ViewGroup emptyListContainer = this.getEmptyListContainerView();
        if (progressBar == null || progressBar.getVisibility() == 0 == loading || emptyListContainer == null || emptyListContainer.getVisibility() != 0) {
            return;
        }
        progressBar.setVisibility(loading ? 0 : 8);
        if (animate) {
            TransitionManager.beginDelayedTransition((ViewGroup)emptyListContainer);
        }
    }

    protected void setListShown(boolean shown) {
        this.setListShown(shown, true);
    }

    protected void setListShown(boolean shown, boolean animate) {
        Z listView = this.getListView();
        ViewGroup emptyListContainer = this.getEmptyListContainerView();
        if (listView != null && listView.getVisibility() == 0 != shown) {
            listView.setVisibility(shown ? 0 : 8);
            if (animate) {
                listView.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)(shown ? 0x10A0000 : 0x10A0001)));
            }
        }
        if (emptyListContainer != null && emptyListContainer.getVisibility() == 0 == shown) {
            emptyListContainer.setVisibility(shown ? 8 : 0);
        }
    }

    protected void setListView(Z listView) {
        this.mListView = listView;
    }

    protected void setProgressBar(ProgressBar progressBar) {
        this.mProgressBar = progressBar;
    }

    public void showEmptyListActionButton(boolean show) {
        this.getEmptyListActionButton().setVisibility(show ? 0 : 8);
    }

    public void useEmptyListActionButton(String buttonText, View.OnClickListener clickListener) {
        Button actionButton = this.getEmptyListActionButton();
        actionButton.setText((CharSequence)buttonText);
        actionButton.setOnClickListener(clickListener);
        this.showEmptyListActionButton(true);
    }

    public static class ListLoader<G>
    extends AsyncTaskLoader<List<G>> {
        private ListAdapterBase<G> mAdapter;

        public ListLoader(ListAdapterBase<G> adapter) {
            super(adapter.getContext());
            this.mAdapter = adapter;
        }

        protected void onStartLoading() {
            super.onStartLoading();
            this.forceLoad();
        }

        public List<G> loadInBackground() {
            return this.mAdapter.onLoad();
        }
    }

    private class RefreshLoaderCallback
    implements LoaderManager.LoaderCallbacks<List<T>> {
        private boolean mRunning = false;
        private boolean mReloadRequested = false;

        private RefreshLoaderCallback() {
        }

        @NonNull
        public Loader<List<T>> onCreateLoader(int id2, Bundle args) {
            this.mReloadRequested = false;
            this.mRunning = true;
            if (ListFragment.this.getAdapter().getCount() == 0) {
                ListFragment.this.setListShown(false);
            }
            ListFragment.this.setListLoading(true);
            return ListFragment.this.createLoader();
        }

        public void onLoadFinished(@NonNull Loader<List<T>> loader, List<T> data) {
            if (ListFragment.this.isResumed()) {
                ListFragment.this.onPrepareRefreshingList();
                ListFragment.this.getAdapter().onUpdate(data);
                ListFragment.this.getAdapter().onDataSetChanged();
                ListFragment.this.setListLoading(false);
                ListFragment.this.onListRefreshed();
            }
            if (this.isReloadRequested()) {
                this.refresh();
            }
            this.mRunning = false;
        }

        public void onLoaderReset(@NonNull Loader<List<T>> loader) {
        }

        public boolean isRunning() {
            return this.mRunning;
        }

        public boolean isReloadRequested() {
            return this.mReloadRequested;
        }

        public void refresh() {
            LoaderManager.getInstance((LifecycleOwner)ListFragment.this).restartLoader(0, null, (LoaderManager.LoaderCallbacks)ListFragment.this.mRefreshLoaderCallback);
        }

        public boolean requestRefresh() {
            if (this.isRunning() && this.isReloadRequested()) {
                return false;
            }
            if (!this.isRunning()) {
                this.refresh();
            } else {
                this.mReloadRequested = true;
            }
            return true;
        }
    }
}

