/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.widget.recyclerview.fastscroll;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.genonbeta.android.framework.widget.recyclerview.FastScroller;
import java.util.ArrayList;
import java.util.List;

public class RecyclerViewScrollListener
extends RecyclerView.OnScrollListener {
    private final FastScroller mScroller;
    private List<ScrollerListener> mListeners = new ArrayList<ScrollerListener>();
    private int mOldScrollState = 0;

    public RecyclerViewScrollListener(FastScroller scroller) {
        this.mScroller = scroller;
    }

    public void addScrollerListener(ScrollerListener listener) {
        this.mListeners.add(listener);
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newScrollState) {
        super.onScrollStateChanged(recyclerView, newScrollState);
        if (newScrollState == 0 && this.mOldScrollState != 0) {
            this.mScroller.getViewProvider().onScrollFinished();
        } else if (newScrollState != 0 && this.mOldScrollState == 0) {
            this.mScroller.getViewProvider().onScrollStarted();
        }
        this.mOldScrollState = newScrollState;
    }

    public void onScrolled(@NonNull RecyclerView rv, int dx, int dy) {
        if (this.mScroller.shouldUpdateHandlePosition()) {
            this.updateHandlePosition(rv);
        }
    }

    public void updateHandlePosition(RecyclerView rv) {
        int range;
        int extent;
        int offset;
        if (this.mScroller.isVertical()) {
            offset = rv.computeVerticalScrollOffset();
            extent = rv.computeVerticalScrollExtent();
            range = rv.computeVerticalScrollRange();
        } else {
            offset = rv.computeHorizontalScrollOffset();
            extent = rv.computeHorizontalScrollExtent();
            range = rv.computeHorizontalScrollRange();
        }
        float relativePos = offset <= extent ? (offset <= 0 ? 0.0f : ((float)offset + (float)extent * ((float)offset / (float)(range - extent))) / (float)range) : (float)(offset + extent) / (float)range;
        this.mScroller.setScrollerPosition(relativePos);
        this.notifyListeners(relativePos);
    }

    public void notifyListeners(float relativePos) {
        for (ScrollerListener listener : this.mListeners) {
            listener.onScroll(relativePos);
        }
    }

    public static interface ScrollerListener {
        public void onScroll(float var1);
    }
}

