/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.widget.recyclerview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.widget.TextViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.genonbeta.android.framework.R;
import com.genonbeta.android.framework.widget.recyclerview.fastscroll.RecyclerViewScrollListener;
import com.genonbeta.android.framework.widget.recyclerview.fastscroll.SectionTitleProvider;
import com.genonbeta.android.framework.widget.recyclerview.fastscroll.Utils;
import com.genonbeta.android.framework.widget.recyclerview.fastscroll.provider.DefaultScrollerViewProvider;
import com.genonbeta.android.framework.widget.recyclerview.fastscroll.provider.ScrollerViewProvider;

public class FastScroller
extends LinearLayout {
    private static final int STYLE_NONE = -1;
    private final RecyclerViewScrollListener mScrollListener = new RecyclerViewScrollListener(this);
    private RecyclerView mRecyclerView;
    private View mBubble;
    private View mHandle;
    private TextView mBubbleTextView;
    private int mBubbleOffset;
    private int mHandleColor;
    private int mBubbleColor;
    private int mBubbleTextAppearance;
    private int mScrollerOrientation;
    private int mMaxVisibility;
    private boolean mManuallyChangingPosition;
    private ScrollerViewProvider mViewProvider;
    private SectionTitleProvider mTitleProvider;

    public FastScroller(Context context) {
        this(context, null);
    }

    public FastScroller(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FastScroller(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setClipChildren(false);
        TypedArray style = context.obtainStyledAttributes(attrs, R.styleable.GenfwFastScroller, R.attr.genfw_fastScrollStyle, 0);
        try {
            this.mBubbleColor = style.getColor(R.styleable.GenfwFastScroller_genfw_fastScrollBubbleColor, -1);
            this.mHandleColor = style.getColor(R.styleable.GenfwFastScroller_genfw_fastScrollHandleColor, -1);
            this.mBubbleTextAppearance = style.getResourceId(R.styleable.GenfwFastScroller_genfw_fastScrollBubbleTextAppearance, -1);
        }
        finally {
            style.recycle();
        }
        this.mMaxVisibility = this.getVisibility();
        this.setViewProvider(new DefaultScrollerViewProvider());
    }

    public void setRecyclerView(RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        if (recyclerView.getAdapter() instanceof SectionTitleProvider) {
            this.mTitleProvider = (SectionTitleProvider)recyclerView.getAdapter();
        }
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.mScrollListener);
        this.invalidateVisibility();
        recyclerView.setOnHierarchyChangeListener(new ViewGroup.OnHierarchyChangeListener(){

            public void onChildViewAdded(View parent, View child) {
                FastScroller.this.invalidateVisibility();
            }

            public void onChildViewRemoved(View parent, View child) {
                FastScroller.this.invalidateVisibility();
            }
        });
    }

    public void setOrientation(int orientation) {
        this.mScrollerOrientation = orientation;
        super.setOrientation(orientation == 0 ? 1 : 0);
    }

    public void setBubbleColor(int color) {
        this.mBubbleColor = color;
        this.invalidate();
    }

    public void setHandleColor(int color) {
        this.mHandleColor = color;
        this.invalidate();
    }

    public void setBubbleTextAppearance(int textAppearanceResourceId) {
        this.mBubbleTextAppearance = textAppearanceResourceId;
        this.invalidate();
    }

    public void addScrollerListener(RecyclerViewScrollListener.ScrollerListener listener) {
        this.mScrollListener.addScrollerListener(listener);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.initHandleMovement();
        this.mBubbleOffset = this.mViewProvider.getBubbleOffset();
        this.applyStyling();
        if (!this.isInEditMode()) {
            // empty if block
        }
    }

    private void applyStyling() {
        if (this.mBubbleColor != -1) {
            this.setBackgroundTint((View)this.mBubbleTextView, this.mBubbleColor);
        }
        if (this.mHandleColor != -1) {
            this.setBackgroundTint(this.mHandle, this.mHandleColor);
        }
        if (this.mBubbleTextAppearance != -1) {
            TextViewCompat.setTextAppearance((TextView)this.mBubbleTextView, (int)this.mBubbleTextAppearance);
        }
    }

    private void setBackgroundTint(View view, int color) {
        Drawable background = DrawableCompat.wrap((Drawable)view.getBackground());
        DrawableCompat.setTint((Drawable)background.mutate(), (int)color);
        Utils.setBackground(view, background);
    }

    private void initHandleMovement() {
        this.mHandle.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                FastScroller.this.requestDisallowInterceptTouchEvent(true);
                if (event.getAction() == 0 || event.getAction() == 2) {
                    if (FastScroller.this.mTitleProvider != null && event.getAction() == 0) {
                        FastScroller.this.mViewProvider.onHandleGrabbed();
                    }
                    FastScroller.this.mManuallyChangingPosition = true;
                    float relativePos = FastScroller.this.getRelativeTouchPosition(event);
                    FastScroller.this.setScrollerPosition(relativePos);
                    FastScroller.this.setRecyclerViewPosition(relativePos);
                    return true;
                }
                if (event.getAction() == 1) {
                    FastScroller.this.mManuallyChangingPosition = false;
                    FastScroller.this.mRecyclerView.scrollBy(0, 0);
                    if (FastScroller.this.mTitleProvider != null) {
                        FastScroller.this.mViewProvider.onHandleReleased();
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private float getRelativeTouchPosition(MotionEvent event) {
        if (this.isVertical()) {
            float yInParent = event.getRawY() - Utils.getViewRawY(this.mHandle);
            return yInParent / (float)(this.getHeight() - this.mHandle.getHeight());
        }
        float xInParent = event.getRawX() - Utils.getViewRawX(this.mHandle);
        return xInParent / (float)(this.getWidth() - this.mHandle.getWidth());
    }

    public void setVisibility(int visibility) {
        this.mMaxVisibility = visibility;
        this.invalidateVisibility();
    }

    private void invalidateVisibility() {
        if (this.mRecyclerView.getAdapter() == null || this.mRecyclerView.getAdapter().getItemCount() == 0 || this.mRecyclerView.getChildAt(0) == null || this.isRecyclerViewNotScrollable() || this.mMaxVisibility != 0) {
            super.setVisibility(4);
        } else {
            super.setVisibility(0);
        }
    }

    private boolean isRecyclerViewNotScrollable() {
        if (this.isVertical()) {
            return this.mRecyclerView.getChildAt(0).getHeight() * this.mRecyclerView.getAdapter().getItemCount() <= this.mRecyclerView.getHeight();
        }
        return this.mRecyclerView.getChildAt(0).getWidth() * this.mRecyclerView.getAdapter().getItemCount() <= this.mRecyclerView.getWidth();
    }

    private void setRecyclerViewPosition(float relativePos) {
        float expectedPosition;
        int targetPos;
        int range;
        int extent;
        int offset;
        if (this.mRecyclerView == null || this.mRecyclerView.getAdapter() == null) {
            return;
        }
        if (this.isVertical()) {
            offset = this.mRecyclerView.computeVerticalScrollOffset();
            extent = this.mRecyclerView.computeVerticalScrollExtent();
            range = this.mRecyclerView.computeVerticalScrollRange();
        } else {
            offset = this.mRecyclerView.computeHorizontalScrollOffset();
            extent = this.mRecyclerView.computeHorizontalScrollExtent();
            range = this.mRecyclerView.computeHorizontalScrollRange();
        }
        View viewUnder = this.isVertical() ? this.mRecyclerView.findChildViewUnder(0.0f, this.mHandle.getY()) : this.mRecyclerView.findChildViewUnder(this.mHandle.getX(), 0.0f);
        RecyclerView.ViewHolder viewHolder = viewUnder == null ? null : this.mRecyclerView.findContainingViewHolder(viewUnder);
        int itemCount = this.mRecyclerView.getAdapter().getItemCount();
        int n = targetPos = viewHolder == null ? -1 : viewHolder.getAdapterPosition();
        if (targetPos < 0 || targetPos >= itemCount) {
            targetPos = (int)Utils.getValueInRange(0.0f, itemCount - 1, (int)(relativePos * (float)itemCount));
        }
        if (this.mTitleProvider != null && this.mBubbleTextView != null) {
            this.mBubbleTextView.setText((CharSequence)this.mTitleProvider.getSectionTitle(targetPos));
        }
        if ((expectedPosition = (float)range * relativePos) <= (float)extent && offset == 0) {
            return;
        }
        int difference = (int)(expectedPosition - (float)(offset + extent));
        if (this.isVertical()) {
            this.mRecyclerView.scrollBy(0, difference);
        } else {
            this.mRecyclerView.scrollBy(difference, 0);
        }
    }

    public void setScrollerPosition(float relativePos) {
        if (this.isVertical()) {
            this.mBubble.setY(Utils.getValueInRange(0.0f, this.getHeight() - this.mBubble.getHeight(), relativePos * (float)(this.getHeight() - this.mHandle.getHeight()) + (float)this.mBubbleOffset));
            this.mHandle.setY(Utils.getValueInRange(0.0f, this.getHeight() - this.mHandle.getHeight(), relativePos * (float)(this.getHeight() - this.mHandle.getHeight())));
        } else {
            this.mBubble.setX(Utils.getValueInRange(0.0f, this.getWidth() - this.mBubble.getWidth(), relativePos * (float)(this.getWidth() - this.mHandle.getWidth()) + (float)this.mBubbleOffset));
            this.mHandle.setX(Utils.getValueInRange(0.0f, this.getWidth() - this.mHandle.getWidth(), relativePos * (float)(this.getWidth() - this.mHandle.getWidth())));
        }
    }

    public boolean isVertical() {
        return this.mScrollerOrientation == 1;
    }

    public boolean shouldUpdateHandlePosition() {
        return this.mHandle != null && !this.mManuallyChangingPosition && this.mRecyclerView.getChildCount() > 0;
    }

    public ScrollerViewProvider getViewProvider() {
        return this.mViewProvider;
    }

    public void setViewProvider(ScrollerViewProvider viewProvider) {
        this.removeAllViews();
        this.mViewProvider = viewProvider;
        viewProvider.setFastScroller(this);
        this.mBubble = viewProvider.provideBubbleView((ViewGroup)this);
        this.mHandle = viewProvider.provideHandleView((ViewGroup)this);
        this.mBubbleTextView = viewProvider.provideBubbleTextView();
        this.addView(this.mBubble);
        this.addView(this.mHandle);
    }
}

