/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.widget.recyclerview.fastscroll;

import androidx.recyclerview.widget.RecyclerView;
import com.genonbeta.android.framework.widget.recyclerview.FastScroller;
import java.util.ArrayList;
import java.util.List;

public class RecyclerViewScrollListener
extends RecyclerView.OnScrollListener {
    private final FastScroller mScroller;
    private List<ScrollerListener> mListeners = new ArrayList<ScrollerListener>();
    private int mOldScrollState = 0;

    public RecyclerViewScrollListener(FastScroller scroller) {
        this.mScroller = scroller;
    }

    public void addScrollerListener(ScrollerListener listener) {
        this.mListeners.add(listener);
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newScrollState) {
        super.onScrollStateChanged(recyclerView, newScrollState);
        if (newScrollState == 0 && this.mOldScrollState != 0) {
            this.mScroller.getViewProvider().onScrollFinished();
        } else if (newScrollState != 0 && this.mOldScrollState == 0) {
            this.mScroller.getViewProvider().onScrollStarted();
        }
        this.mOldScrollState = newScrollState;
    }

    public void onScrolled(RecyclerView rv, int dx, int dy) {
        if (this.mScroller.shouldUpdateHandlePosition()) {
            this.updateHandlePosition(rv);
        }
    }

    public void updateHandlePosition(RecyclerView rv) {
        float relativePos;
        if (this.mScroller.isVertical()) {
            int offset = rv.computeVerticalScrollOffset();
            int extent = rv.computeVerticalScrollExtent();
            int range = rv.computeVerticalScrollRange();
            relativePos = (float)offset / (float)(range - extent);
        } else {
            int offset = rv.computeHorizontalScrollOffset();
            int extent = rv.computeHorizontalScrollExtent();
            int range = rv.computeHorizontalScrollRange();
            relativePos = (float)offset / (float)(range - extent);
        }
        this.mScroller.setScrollerPosition(relativePos);
        this.notifyListeners(relativePos);
    }

    public void notifyListeners(float relativePos) {
        for (ScrollerListener listener : this.mListeners) {
            listener.onScroll(relativePos);
        }
    }

    public static interface ScrollerListener {
        public void onScroll(float var1);
    }
}

