/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.updatewithgithub;

import android.app.DownloadManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Environment;
import android.os.Looper;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import android.widget.Toast;
import com.genonbeta.android.framework.R;
import com.genonbeta.android.updatewithgithub.ComparableVersion;
import com.genonbeta.android.updatewithgithub.RemoteServer;
import java.io.File;
import org.json.JSONArray;
import org.json.JSONObject;

public class GitHubUpdater {
    public static final String TAG = GitHubUpdater.class.getSimpleName();
    private Context mContext;
    private String mRepo;
    private int mThemeRes;
    private boolean mPreReleaseIncluded;

    public GitHubUpdater(Context context, String repo, int themeRes, boolean preReleaseIncluded) {
        this.mContext = context;
        this.mRepo = repo;
        this.mThemeRes = themeRes;
        this.mPreReleaseIncluded = preReleaseIncluded;
    }

    public void checkForUpdates(final boolean popupDialog, final OnInfoAvailableListener listener) {
        if (popupDialog) {
            Toast.makeText((Context)this.mContext, (int)R.string.genfw_uwg_check_for_updates_ongoing, (int)1).show();
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block17: {
                    super.run();
                    Looper.prepare();
                    try {
                        Log.d((String)TAG, (String)"Checking updates");
                        GitHubUpdater.this.mContext.setTheme(GitHubUpdater.this.mThemeRes);
                        RemoteServer server = new RemoteServer(GitHubUpdater.this.mRepo);
                        String result = server.connect(null, null);
                        Log.d((String)TAG, (String)"Server connected");
                        PackageInfo packInfo = GitHubUpdater.this.mContext.getPackageManager().getPackageInfo(((GitHubUpdater)GitHubUpdater.this).mContext.getApplicationInfo().packageName, 0);
                        String appVersionName = packInfo.versionName;
                        final String applicationName = GitHubUpdater.this.getAppLabel(GitHubUpdater.this.mContext);
                        JSONArray releases = new JSONArray(result);
                        if (releases.length() <= 0) break block17;
                        Log.d((String)TAG, (String)("Reading releases: (total) " + releases.length()));
                        for (int iterator = 0; iterator < releases.length(); ++iterator) {
                            JSONObject selectedRelease = releases.getJSONObject(iterator);
                            boolean isPreRelease = selectedRelease.getBoolean("prerelease");
                            if (isPreRelease && !GitHubUpdater.this.mPreReleaseIncluded) continue;
                            final String lastVersionName = selectedRelease.getString("tag_name");
                            String lastVersionTitle = selectedRelease.getString("name");
                            String lastVersionDate = selectedRelease.getString("published_at");
                            String lastVersionBody = selectedRelease.getString("body");
                            ComparableVersion comLast = new ComparableVersion(lastVersionName);
                            ComparableVersion comCurr = new ComparableVersion(appVersionName);
                            if (listener != null) {
                                listener.onInfoAvailable(comLast.compareTo(comCurr) > 0, lastVersionName, lastVersionTitle, lastVersionBody, lastVersionDate);
                            }
                            final File updateFile = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS) + "/" + applicationName + " v" + lastVersionName + ".apk");
                            if (popupDialog && comLast.compareTo(comCurr) > 0) {
                                Log.d((String)TAG, (String)("New version found: " + lastVersionName));
                                if (selectedRelease.has("assets")) {
                                    Log.d((String)TAG, (String)"Reading assets");
                                    JSONArray releaseAssets = selectedRelease.getJSONArray("assets");
                                    if (releaseAssets.length() > 0) {
                                        Log.d((String)TAG, (String)("Assets is cached: (total) " + releaseAssets.length()));
                                        JSONObject firstAsset = releaseAssets.getJSONObject(0);
                                        final String downloadURL = firstAsset.getString("browser_download_url");
                                        DialogInterface.OnClickListener downloadStart = new DialogInterface.OnClickListener(){

                                            public void onClick(DialogInterface dialog, int which) {
                                                if (updateFile.isFile()) {
                                                    updateFile.delete();
                                                }
                                                DownloadManager manager = (DownloadManager)GitHubUpdater.this.mContext.getSystemService("download");
                                                DownloadManager.Request downloadRequest = new DownloadManager.Request(Uri.parse((String)downloadURL));
                                                downloadRequest.setTitle((CharSequence)GitHubUpdater.this.mContext.getString(R.string.genfw_uwg_downloading_update_title, new Object[]{applicationName, lastVersionName}));
                                                downloadRequest.setDescription((CharSequence)GitHubUpdater.this.mContext.getString(R.string.genfw_uwg_downloading_update_description, new Object[]{applicationName}));
                                                downloadRequest.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, applicationName + " v" + lastVersionName + ".apk");
                                                downloadRequest.setMimeType("application/vnd.android.package-archive");
                                                downloadRequest.setNotificationVisibility(1);
                                                manager.enqueue(downloadRequest);
                                            }
                                        };
                                        DialogInterface.OnClickListener openDownloads = new DialogInterface.OnClickListener(){

                                            public void onClick(DialogInterface dialog, int which) {
                                                GitHubUpdater.this.mContext.startActivity(new Intent("android.intent.action.VIEW_DOWNLOADS"));
                                            }
                                        };
                                        AlertDialog.Builder dialog = new AlertDialog.Builder(GitHubUpdater.this.mContext).setTitle(R.string.genfw_uwg_update_available);
                                        if (updateFile.isFile()) {
                                            Log.d((String)TAG, (String)("File already exists: " + updateFile.getName()));
                                            dialog.setMessage(R.string.genfw_uwg_update_exists).setNeutralButton(R.string.genfw_uwg_download, downloadStart).setPositiveButton(R.string.genfw_uwg_open, openDownloads);
                                        } else {
                                            Log.d((String)TAG, (String)"Update is downloadable");
                                            dialog.setMessage((CharSequence)String.format(GitHubUpdater.this.mContext.getString(R.string.genfw_uwg_update_body), appVersionName, lastVersionName, lastVersionDate, lastVersionBody)).setPositiveButton(R.string.genfw_uwg_download_now, downloadStart);
                                        }
                                        dialog.setNegativeButton(R.string.genfw_uwg_later, null).show();
                                    } else {
                                        Log.d((String)TAG, (String)"No downloadable file is provided");
                                    }
                                } else {
                                    Toast.makeText((Context)GitHubUpdater.this.mContext, (int)R.string.genfw_uwg_no_update_available, (int)1).show();
                                }
                            } else if (popupDialog) {
                                Toast.makeText((Context)GitHubUpdater.this.mContext, (int)R.string.genfw_uwg_currently_latest_version_info, (int)1).show();
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Log.d((String)TAG, (String)"Error occurred");
                        if (popupDialog) {
                            Toast.makeText((Context)GitHubUpdater.this.mContext, (int)R.string.genfw_uwg_version_check_error, (int)1).show();
                        }
                    }
                    finally {
                        Looper.loop();
                    }
                }
            }
        }.start();
    }

    public String getAppLabel(Context context) {
        PackageManager packageManager = context.getPackageManager();
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = packageManager.getApplicationInfo(context.getApplicationInfo().packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return applicationInfo != null ? packageManager.getApplicationLabel(applicationInfo) : "Unknown";
    }

    public static boolean isNewVersion(Context context, String comparedVersionName) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getApplicationInfo().packageName, 0);
            ComparableVersion comparableGiven = new ComparableVersion(comparedVersionName);
            ComparableVersion comparableCurrent = new ComparableVersion(packageInfo.versionName);
            return comparableGiven.compareTo(comparableCurrent) > 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isNewVersion(String comparedVersionName) {
        return GitHubUpdater.isNewVersion(this.mContext, comparedVersionName);
    }

    public static interface OnInfoAvailableListener {
        public void onInfoAvailable(boolean var1, String var2, String var3, String var4, String var5);
    }
}

