/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.util.date;

import android.support.annotation.NonNull;
import com.genonbeta.android.framework.util.listing.ComparableMerger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateMerger<T>
extends ComparableMerger<T> {
    private long mTime;
    private int mYear;
    private int mMonth;
    private int mDay;
    private int mDayOfYear;

    public DateMerger(long time) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(new Date(time));
        this.mTime = time;
        this.mYear = calendar.get(1);
        this.mMonth = calendar.get(2);
        this.mDay = calendar.get(5);
        this.mDayOfYear = calendar.get(6);
    }

    @Override
    public int compareTo(@NonNull ComparableMerger<T> merger) {
        if (!(merger instanceof DateMerger)) {
            return -1;
        }
        DateMerger o = (DateMerger)merger;
        if (this.getYear() < o.getYear()) {
            return -1;
        }
        if (this.getYear() > o.getYear()) {
            return 1;
        }
        if (this.getDayOfYear() == o.getDayOfYear()) {
            return 0;
        }
        return this.getDayOfYear() < o.getDayOfYear() ? -1 : 1;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DateMerger)) {
            return false;
        }
        DateMerger dateMerger = (DateMerger)obj;
        return this.getYear() == dateMerger.getYear() && this.getMonth() == dateMerger.getMonth() && this.getDay() == dateMerger.getDay();
    }

    public int getDay() {
        return this.mDay;
    }

    public int getDayOfYear() {
        return this.mDayOfYear;
    }

    public int getMonth() {
        return this.mMonth;
    }

    public long getTime() {
        return this.mTime;
    }

    public int getYear() {
        return this.mYear;
    }
}

