/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.io;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.DocumentsContract;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.genonbeta.android.framework.io.DocumentFile;
import java.io.Closeable;
import java.io.FileNotFoundException;

@RequiresApi(value=21)
public class TreeDocumentFile
extends DocumentFile {
    private Context mContext;
    private Uri mUri;
    private String mId;
    private String mName;
    private String mType;
    private long mLength;
    private long mFlags;
    private long mLastModified;
    private boolean mExists;

    public TreeDocumentFile(DocumentFile parent, Context context, Uri uri) throws Exception {
        super(parent);
        this.mContext = context;
        this.mUri = uri;
        this.sync();
    }

    public TreeDocumentFile(DocumentFile parent, Context context, Cursor cursor) {
        super(parent);
        this.mContext = context;
        if (this.loadFrom(cursor)) {
            this.mUri = DocumentsContract.buildDocumentUriUsingTree((Uri)parent.getUri(), (String)this.mId);
        }
    }

    @Override
    public DocumentFile createFile(String mimeType, String displayName) {
        try {
            Uri newFile = DocumentsContract.createDocument((ContentResolver)this.mContext.getContentResolver(), (Uri)this.mUri, (String)mimeType, (String)displayName);
            if (newFile != null) {
                return new TreeDocumentFile((DocumentFile)this, this.mContext, newFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public DocumentFile createDirectory(String displayName) {
        return this.createFile("vnd.android.document/directory", displayName);
    }

    public long getFlags() {
        return this.mFlags;
    }

    @Override
    public Uri getUri() {
        return this.mUri;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getType() {
        return this.mType;
    }

    @Override
    public boolean isDirectory() {
        return "vnd.android.document/directory".equals(this.mType);
    }

    @Override
    public boolean isFile() {
        return !"vnd.android.document/directory".equals(this.mType) || TextUtils.isEmpty((CharSequence)this.mType);
    }

    @Override
    @RequiresApi(api=24)
    public boolean isVirtual() {
        return (this.getFlags() & 0x200L) != 0L;
    }

    @Override
    public long lastModified() {
        return this.mLastModified;
    }

    @Override
    public long length() {
        return this.mLength;
    }

    protected boolean loadFrom(Cursor cursor) {
        if (cursor == null) {
            return false;
        }
        int idIndex = cursor.getColumnIndex("document_id");
        int nameIndex = cursor.getColumnIndex("_display_name");
        int sizeIndex = cursor.getColumnIndex("_size");
        int typeIndex = cursor.getColumnIndex("mime_type");
        int flagIndex = cursor.getColumnIndex("flags");
        int modifiedIndex = cursor.getColumnIndex("last_modified");
        if (idIndex == -1 || nameIndex == -1 || sizeIndex == -1 || typeIndex == -1 || flagIndex == -1 || modifiedIndex == -1) {
            return false;
        }
        this.mId = cursor.getString(idIndex);
        this.mName = cursor.getString(nameIndex);
        this.mLastModified = cursor.getLong(modifiedIndex);
        this.mLength = cursor.getLong(sizeIndex);
        this.mType = cursor.getString(typeIndex);
        this.mFlags = cursor.getLong(flagIndex);
        this.mExists = true;
        return true;
    }

    @Override
    public boolean canRead() {
        return this.mContext.checkCallingOrSelfUriPermission(this.mUri, 1) == 0;
    }

    @Override
    public boolean canWrite() {
        return this.mContext.checkCallingOrSelfUriPermission(this.mUri, 2) == 0;
    }

    @Override
    public boolean delete() {
        try {
            return DocumentsContract.deleteDocument((ContentResolver)this.mContext.getContentResolver(), (Uri)this.mUri);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean exists() {
        return this.mExists;
    }

    @Override
    public DocumentFile[] listFiles() {
        try {
            Uri treeUri = DocumentsContract.buildChildDocumentsUriUsingTree((Uri)this.mUri, (String)DocumentsContract.getDocumentId((Uri)this.mUri));
            Cursor cursor = this.mContext.getContentResolver().query(treeUri, null, null, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                return new DocumentFile[0];
            }
            DocumentFile[] resultFiles = new DocumentFile[cursor.getCount()];
            do {
                resultFiles[cursor.getPosition()] = new TreeDocumentFile((DocumentFile)this, this.mContext, cursor);
            } while (cursor.moveToNext());
            TreeDocumentFile.closeQuietly((Closeable)cursor);
            return resultFiles;
        }
        catch (Exception exception) {
            return new DocumentFile[0];
        }
    }

    @Override
    public boolean renameTo(String displayName) {
        try {
            return DocumentsContract.renameDocument((ContentResolver)this.mContext.getContentResolver(), (Uri)this.mUri, (String)displayName) != null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sync() throws Exception {
        Cursor cursor;
        block4: {
            this.mExists = false;
            ContentResolver resolver = this.mContext.getContentResolver();
            cursor = null;
            try {
                cursor = resolver.query(this.mUri, null, null, null, null);
                if (cursor == null || !cursor.moveToFirst() || !this.loadFrom(cursor)) break block4;
            }
            catch (Exception e) {
                try {
                    Log.w((String)TAG, (String)("Failed query: " + e));
                    throw e;
                }
                catch (Throwable throwable) {
                    TreeDocumentFile.closeQuietly(cursor);
                    throw throwable;
                }
            }
            TreeDocumentFile.closeQuietly((Closeable)cursor);
            return;
        }
        TreeDocumentFile.closeQuietly((Closeable)cursor);
        throw new Exception("Failed to sync()");
    }
}

