/*
 * Decompiled with CFR 0.152.
 */
package com.geely.gbop.api.sign;

import com.geely.gbop.api.sign.HmacAuthSha256Sign;
import com.geely.gbop.api.sign.ISigner;
import com.geely.gbop.api.sign.SignMehod;
import java.util.HashMap;
import java.util.Map;

public class SignerManager {
    private static Map<String, ISigner> factoryMap = new HashMap<String, ISigner>(2);

    private static ISigner registerSigner(String method, ISigner factory) {
        return factoryMap.put(method, factory);
    }

    public static ISigner lookup(SignMehod method) {
        if (method == null) {
            return factoryMap.get(HmacAuthSha256Sign.METHOD);
        }
        ISigner signer = factoryMap.get(method.getMethod());
        if (signer == null) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5\uff1a" + method.getMethod());
        }
        return signer;
    }

    static {
        SignerManager.registerSigner(SignMehod.HmacSha256.getMethod(), new HmacAuthSha256Sign());
    }
}

