/*
 * Decompiled with CFR 0.152.
 */
package com.geely.gbop.api;

import com.geely.gbop.api.contant.HttpContentType;
import com.geely.gbop.api.contant.HttpMethod;
import com.geely.gbop.api.sign.SignMehod;
import com.geely.gbop.api.util.Md5Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;

public class GbopApiRequest {
    private HttpMethod method;
    private String path;
    private Map<String, Object> params;
    private Map<String, String> headers = new HashMap<String, String>();
    private RequestBody body;
    private HttpContentType contentType;
    private List<String> customSignHeaders;
    private SignMehod signMehod;
    private Boolean beta;

    public Boolean getBeta() {
        if (this.beta == null) {
            return false;
        }
        return this.beta;
    }

    public GbopApiRequest beta(Boolean beta) {
        this.beta = beta;
        return this;
    }

    public GbopApiRequest() {
        this.params = new HashMap<String, Object>();
        this.customSignHeaders = new ArrayList<String>();
        this.signMehod = SignMehod.HmacSha256;
    }

    public HttpContentType getContentType() {
        return this.contentType;
    }

    public GbopApiRequest contentType(HttpContentType contentType) {
        this.contentType = contentType;
        this.addHead("Content-Type", contentType.getValue());
        return this;
    }

    public static GbopApiRequest buider() {
        return new GbopApiRequest();
    }

    public SignMehod getSignMehod() {
        return this.signMehod;
    }

    public GbopApiRequest signMehod(SignMehod signMehod) {
        this.signMehod = signMehod;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public GbopApiRequest path(String path) {
        this.path = path;
        return this;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public GbopApiRequest params(Map<String, Object> params) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        if (params != null) {
            this.params.putAll(this.removeBlankParams(params));
        }
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public GbopApiRequest headers(Map<String, String> headers) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        if (headers != null) {
            this.headers.putAll(headers);
        }
        return this;
    }

    public RequestBody getBody() {
        return this.body;
    }

    public GbopApiRequest body(RequestBody body) {
        this.body = body;
        return this;
    }

    public GbopApiRequest addHead(String head, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(head, value);
        return this;
    }

    public GbopApiRequest addParam(String key, String value) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(key, value == null ? "" : value);
        return this;
    }

    public GbopApiRequest addArrayParam(String key, List<String> value) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        if (value == null || value.size() == 0) {
            this.params.put(key, "");
        } else {
            this.params.put(key, this.removeBlankValue(value));
        }
        return this;
    }

    public GbopApiRequest addCustomSignHead(String head) {
        this.customSignHeaders.add(head);
        return this;
    }

    public GbopApiRequest addCustomSignHeads(List<String> heads) {
        this.customSignHeaders.addAll(heads);
        return this;
    }

    public GbopApiRequest method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public List<String> getCustomSignHeaders() {
        return this.customSignHeaders;
    }

    public GbopApiRequest signBody(String bodyStr) {
        String bodyMd5;
        if (StringUtils.isNotEmpty((CharSequence)bodyStr) && !HttpContentType.isStream(this.contentType) && !HttpContentType.isForm(this.contentType) && (bodyMd5 = Md5Util.buildBodyMd5(bodyStr)) != null) {
            this.addHead("X-Gapi-Body-Digest", bodyMd5);
            this.addCustomSignHead("X-Gapi-Body-Digest");
        }
        return this;
    }

    private List<String> removeBlankValue(List value) {
        if (value.size() == 0) {
            return value;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Object va : value) {
            result.add(va == null ? "" : va.toString());
        }
        return result;
    }

    private Map<String, Object> removeBlankParams(Map<String, Object> queries) {
        if (queries.size() == 0) {
            return queries;
        }
        Set<Map.Entry<String, Object>> params = queries.entrySet();
        for (Map.Entry<String, Object> entry : params) {
            List<String> tempV;
            if (entry.getValue() == null) {
                entry.setValue("");
                continue;
            }
            if (entry.getValue() instanceof List) {
                tempV = this.removeBlankValue((List)entry.getValue());
                if (tempV == null || tempV.size() == 0) {
                    entry.setValue("");
                    continue;
                }
                entry.setValue(tempV);
                continue;
            }
            if (!entry.getValue().getClass().isArray()) continue;
            tempV = this.removeBlankValue(Arrays.asList((Object[])entry.getValue()).stream().map(e -> e.toString()).collect(Collectors.toList()));
            if (tempV == null || tempV.size() == 0) {
                entry.setValue("");
                continue;
            }
            entry.setValue(tempV);
        }
        return queries;
    }
}

