/*
 * Decompiled with CFR 0.152.
 */
package com.geely.gbop.api;

import com.geely.gbop.api.GbopApiApp;
import com.geely.gbop.api.GbopApiRequest;
import com.geely.gbop.api.GbopApiResponse;
import com.geely.gbop.api.util.GbopHttpBuild;
import com.geely.gbop.api.util.GbopHttpsUtil;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class GbopApiClient {
    private GbopApiApp app;
    private String serverHost;
    private OkHttpClient httpClient;

    public GbopApiClient(GbopApiApp app, String serverHost) {
        this.app = app;
        this.serverHost = serverHost;
        this.initHttpClient();
    }

    public GbopApiClient(GbopApiApp app, String serverHost, OkHttpClient httpClient) {
        this.app = app;
        this.serverHost = serverHost;
        this.httpClient = httpClient;
    }

    private void initHttpClient() {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        okHttpClientBuilder.connectTimeout(10L, TimeUnit.SECONDS);
        okHttpClientBuilder.readTimeout(300L, TimeUnit.SECONDS);
        okHttpClientBuilder.writeTimeout(300L, TimeUnit.SECONDS);
        okHttpClientBuilder.followRedirects(true);
        okHttpClientBuilder.retryOnConnectionFailure(true);
        okHttpClientBuilder.hostnameVerifier(GbopHttpsUtil.getHostnameVerifier());
        okHttpClientBuilder.sslSocketFactory(GbopHttpsUtil.getSSLSocketFactory(), GbopHttpsUtil.getX509TrustManager());
        this.httpClient = okHttpClientBuilder.build();
    }

    public GbopApiResponse syncHttpCall(GbopApiRequest apiRequest) {
        Request request = GbopHttpBuild.buildRequest(apiRequest, this.app, this.serverHost);
        try (Response response = null;){
            response = this.httpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                GbopApiResponse gbopApiResponse = new GbopApiResponse(response.code(), response.body().string());
                return gbopApiResponse;
            }
            GbopApiResponse gbopApiResponse = new GbopApiResponse(response.code(), response.body().string(), response.message());
            return gbopApiResponse;
        }
    }

    public Response execute(GbopApiRequest apiRequest) throws IOException {
        Request request = GbopHttpBuild.buildRequest(apiRequest, this.app, this.serverHost);
        return this.httpClient.newCall(request).execute();
    }

    public OkHttpClient getOkHttpClient() {
        return this.httpClient;
    }
}

