/*
 * Decompiled with CFR 0.152.
 */
package com.garena.devalert.library.enabled;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.garena.devalert.library.R;
import com.garena.devalert.library.enabled.DevAlertData;
import com.garena.devalert.library.enabled.DevAlertDialog;
import com.garena.devalert.library.enabled.DevAlertEnabled;

class DevAlertHintView
extends FrameLayout {
    private final DevAlertData mData;
    private final DevAlertEnabled mManager;
    private TextView mTextView;
    private TextView mDismissBtn;
    private TextView mSeeMore;

    public DevAlertHintView(Context context, DevAlertData data, DevAlertEnabled manager) {
        super(context);
        this.mData = data;
        this.mManager = manager;
        this.initView(context);
    }

    private void initView(final Context context) {
        DevAlertHintView.inflate((Context)context, (int)R.layout.devalert_support_view, (ViewGroup)this);
        this.mTextView = (TextView)this.findViewById(R.id.title);
        this.mDismissBtn = (TextView)this.findViewById(R.id.dismiss_btn);
        this.mDismissBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ViewGroup)DevAlertHintView.this.getParent()).removeView((View)DevAlertHintView.this);
            }
        });
        this.mSeeMore = (TextView)this.findViewById(R.id.see_btn);
        this.mSeeMore.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DevAlertDialog dialog = new DevAlertDialog(context, DevAlertHintView.this.mData, DevAlertHintView.this.mManager);
                dialog.show();
            }
        });
        switch (this.mData.getType()) {
            case 1: {
                this.setBackgroundColor(Color.parseColor((String)"#E80000"));
                break;
            }
            case 2: {
                this.setBackgroundColor(Color.parseColor((String)"#E6B300"));
            }
        }
        String message = this.mData.getMessage();
        Throwable throwable = this.mData.getThrowable();
        if (TextUtils.isEmpty((CharSequence)message)) {
            this.mTextView.setText((CharSequence)throwable.getMessage());
        } else if (TextUtils.isEmpty((CharSequence)throwable.getMessage())) {
            this.mTextView.setText((CharSequence)message);
        } else {
            this.mTextView.setText((CharSequence)(message + "\n\n" + throwable.getMessage()));
        }
    }

    public void attach(FrameLayout root) {
        if (root != null && this.getParent() == null) {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
            params.gravity = 80;
            params.setMargins(4, 4, 4, 4);
            root.addView((View)this, (ViewGroup.LayoutParams)params);
            Animation rotationAni = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_in_from_bottom);
            this.startAnimation(rotationAni);
        }
    }
}

