/*
 * Decompiled with CFR 0.152.
 */
package com.garena.devalert.library.enabled;

import android.app.Dialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.garena.devalert.library.R;
import com.garena.devalert.library.enabled.DevAlertData;
import com.garena.devalert.library.enabled.DevAlertEnabled;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class DevAlertFullView
extends FrameLayout {
    private DevAlertData mData;
    private DevAlertEnabled mManager;
    private ListView mTraceListView;
    private TextView mDismissBtn;
    private TextView mHideForeverBtn;
    private TextView mCopyBtn;
    private Dialog mDialog;
    private TextView mText;
    private ClipboardManager mClipboard;

    public DevAlertFullView(Context context, DevAlertData data, DevAlertEnabled manager) {
        super(context);
        this.mData = data;
        this.mManager = manager;
        this.initView(context);
    }

    public void setDialog(Dialog dialog) {
        this.mDialog = dialog;
    }

    private void initView(Context context) {
        DevAlertFullView.inflate((Context)context, (int)R.layout.devalert_support_layout, (ViewGroup)this);
        this.mClipboard = (ClipboardManager)context.getSystemService("clipboard");
        this.mText = (TextView)this.findViewById(R.id.title);
        String message = this.mData.getMessage();
        Throwable throwable = this.mData.getThrowable();
        if (TextUtils.isEmpty((CharSequence)message)) {
            this.mText.setText((CharSequence)throwable.getMessage());
        } else if (TextUtils.isEmpty((CharSequence)throwable.getMessage())) {
            this.mText.setText((CharSequence)message);
        } else {
            this.mText.setText((CharSequence)(message + "\n\n" + throwable.getMessage()));
        }
        this.mDismissBtn = (TextView)this.findViewById(R.id.dismiss_btn);
        this.mDismissBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DevAlertFullView.this.mDialog.dismiss();
            }
        });
        this.mHideForeverBtn = (TextView)this.findViewById(R.id.hide_btn);
        this.mHideForeverBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DevAlertFullView.this.mManager.addToIgnoreList(DevAlertFullView.this.getContext(), DevAlertFullView.this.mData.getTag());
                DevAlertFullView.this.mDialog.dismiss();
            }
        });
        this.mCopyBtn = (TextView)this.findViewById(R.id.copy_btn);
        this.mCopyBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ClipData clipData = ClipData.newPlainText((CharSequence)"Stack Trace", (CharSequence)DevAlertFullView.traceToString(DevAlertFullView.this.mData));
                DevAlertFullView.this.mClipboard.setPrimaryClip(clipData);
                Toast.makeText((Context)DevAlertFullView.this.getContext(), (CharSequence)"Copied to clipboard", (int)0).show();
            }
        });
        this.mTraceListView = (ListView)this.findViewById(R.id.trace_list);
        TraceAdapter adapter = new TraceAdapter();
        adapter.setData(Arrays.asList(this.mData.getThrowable().getStackTrace()));
        this.mTraceListView.setAdapter((ListAdapter)adapter);
        switch (this.mData.getType()) {
            case 1: {
                this.setBackgroundColor(Color.parseColor((String)"#E80000"));
                break;
            }
            case 2: {
                this.setBackgroundColor(Color.parseColor((String)"#E6B300"));
            }
        }
    }

    private static String traceToString(DevAlertData data) {
        String exported = data.getMessage() + "\n";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        data.getThrowable().printStackTrace(pw);
        exported = exported + sw.toString();
        return exported;
    }

    public static class TraceAdapter
    extends BaseAdapter {
        private List<StackTraceElement> mDataSource = new ArrayList<StackTraceElement>();

        public void setData(List<StackTraceElement> data) {
            this.mDataSource = data;
        }

        public int getCount() {
            return this.mDataSource.size();
        }

        public StackTraceElement getItem(int position) {
            return this.mDataSource.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = View.inflate((Context)parent.getContext(), (int)R.layout.devalert_trace_list_item, null);
            }
            TextView title = (TextView)convertView.findViewById(R.id.title);
            TextView subTitle = (TextView)convertView.findViewById(R.id.sub_title);
            StackTraceElement trace = this.getItem(position);
            title.setText((CharSequence)trace.getMethodName());
            subTitle.setText((CharSequence)(trace.getFileName() + ":" + trace.getLineNumber()));
            return convertView;
        }
    }
}

