/*
 * Decompiled with CFR 0.152.
 */
package com.garena.devalert.library.enabled;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.widget.FrameLayout;
import com.garena.devalert.library.DevAlertConfig;
import com.garena.devalert.library.DevAlertManager;
import com.garena.devalert.library.enabled.DevAlertData;
import com.garena.devalert.library.enabled.DevAlertHintView;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.HashSet;

public class DevAlertEnabled
implements DevAlertManager,
Application.ActivityLifecycleCallbacks {
    private final DevAlertConfig mConfig;
    private final HashSet<String> mIgnoredTags;
    private ArrayDeque<DevAlertData> mErrorQueue;
    private ArrayDeque<DevAlertData> mWarningQueue;
    private WeakReference<Activity> mCurrentActivity;

    public DevAlertEnabled(Context context, DevAlertConfig config) {
        this.mConfig = config;
        this.mErrorQueue = new ArrayDeque();
        this.mWarningQueue = new ArrayDeque();
        this.mIgnoredTags = new HashSet<String>(this.mConfig.getIgnoredTags());
        this.mCurrentActivity = new WeakReference<Object>(null);
        this.loadIgnoreList(context);
    }

    @Override
    public void registerLifecycleCallback(Application application) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    @Override
    public synchronized void addWarning(String tag, String message, Throwable ex) {
        if (this.mConfig.isShowWarnings() && !this.mIgnoredTags.contains(tag)) {
            this.mWarningQueue.add(new DevAlertData(2, tag, message, ex));
            this.notify((Activity)this.mCurrentActivity.get());
        }
    }

    @Override
    public synchronized void addError(String tag, String message, Throwable ex) {
        if (this.mConfig.isShowErrors() && !this.mIgnoredTags.contains(tag)) {
            this.mErrorQueue.add(new DevAlertData(1, tag, message, ex));
            this.notify((Activity)this.mCurrentActivity.get());
        }
    }

    @Override
    public synchronized void clearData(Context context) {
        this.mIgnoredTags.clear();
        this.mIgnoredTags.addAll(this.mConfig.getIgnoredTags());
        context.getSharedPreferences(this.mConfig.getSharedPrefName(), 0).edit().putStringSet("ignored_tags", new HashSet()).apply();
    }

    private void notify(final Activity activity) {
        if (activity != null) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    DevAlertEnabled.this.notifyUI(activity);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUI(Activity activity) {
        FrameLayout root = (FrameLayout)activity.findViewById(0x1020002);
        if (root != null) {
            DevAlertData data = null;
            DevAlertEnabled devAlertEnabled = this;
            synchronized (devAlertEnabled) {
                if (!this.mErrorQueue.isEmpty()) {
                    data = this.mErrorQueue.pop();
                } else if (!this.mWarningQueue.isEmpty()) {
                    data = this.mWarningQueue.pop();
                }
            }
            if (data != null) {
                DevAlertHintView hintView = new DevAlertHintView((Context)activity, data, this);
                hintView.attach(root);
            }
        }
    }

    private void saveIgnoreList(Context context) {
        context.getSharedPreferences(this.mConfig.getSharedPrefName(), 0).edit().putStringSet("ignored_tags", this.mIgnoredTags).apply();
    }

    private void loadIgnoreList(Context context) {
        this.mIgnoredTags.addAll(context.getSharedPreferences(this.mConfig.getSharedPrefName(), 0).getStringSet("ignored_tags", new HashSet()));
    }

    void addToIgnoreList(Context context, String tag) {
        this.mIgnoredTags.add(tag);
        this.saveIgnoreList(context);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        this.mCurrentActivity = new WeakReference<Activity>(activity);
        this.notify(activity);
    }

    public void onActivityPaused(Activity activity) {
        this.mCurrentActivity = new WeakReference<Object>(null);
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

