/*
 * Decompiled with CFR 0.152.
 */
package com.garena.devalert.library;

import java.util.ArrayList;
import java.util.List;

public class DevAlertConfig {
    private boolean showErrors;
    private boolean showWarnings;
    private List<String> ignoredTags;
    private String sharedPrefName;

    private DevAlertConfig(Builder builder) {
        this.showErrors = builder.showErrors;
        this.showWarnings = builder.showWarnings;
        this.ignoredTags = builder.ignoredTags;
        this.sharedPrefName = builder.sharedPrefName;
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public boolean isShowWarnings() {
        return this.showWarnings;
    }

    public List<String> getIgnoredTags() {
        return this.ignoredTags;
    }

    public String getSharedPrefName() {
        return this.sharedPrefName;
    }

    public static final class Builder {
        private boolean showErrors = true;
        private boolean showWarnings = true;
        private List<String> ignoredTags = new ArrayList<String>();
        private String sharedPrefName = "com_garena_dev_alert_lib";

        public Builder showErrors(boolean show) {
            this.showErrors = show;
            return this;
        }

        public Builder showWarnings(boolean show) {
            this.showWarnings = show;
            return this;
        }

        public Builder ignoredTags(List<String> ignoredTags) {
            this.ignoredTags = ignoredTags;
            return this;
        }

        public Builder sharedPrefName(String name) {
            this.sharedPrefName = name;
            return this;
        }

        public DevAlertConfig build() {
            return new DevAlertConfig(this);
        }
    }
}

