/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.testng;

import com.galenframework.config.GalenConfig;
import com.galenframework.config.GalenProperty;
import com.galenframework.reports.GalenTestInfo;
import com.galenframework.reports.HtmlReportBuilder;
import com.galenframework.reports.model.FileTempStorage;
import com.galenframework.support.GalenReportsContainer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.xml.XmlSuite;

public class GalenTestNgReportsListener
implements IReporter {
    private static final Logger LOG = LoggerFactory.getLogger(GalenTestNgReportsListener.class);

    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> iSuites, String s) {
        LOG.info("Generating Galen Html reports");
        List<GalenTestInfo> tests = GalenReportsContainer.get().getAllTests();
        try {
            new HtmlReportBuilder().build(tests, GalenConfig.getConfig().readProperty(GalenProperty.TEST_JAVA_REPORT_OUTPUTFOLDER));
            this.cleanData(tests);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void cleanData(List<GalenTestInfo> testInfos) {
        for (GalenTestInfo testInfo : testInfos) {
            if (testInfo.getReport() == null) continue;
            try {
                FileTempStorage storage = testInfo.getReport().getFileStorage();
                if (storage == null) continue;
                storage.cleanup();
            }
            catch (Exception e) {
                LOG.error("Unknown error during report cleaning", (Throwable)e);
            }
        }
    }
}

