/*
 * Decompiled with CFR 0.152.
 */
package com.fulmicoton.multiregexp.benchmark;

import com.fulmicoton.multiregexp.MultiPattern;
import com.fulmicoton.multiregexp.MultiPatternSearcher;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.AutomatonMatcher;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum PatternMethods {
    MULTIPATTERN{

        @Override
        PatternMatchingMethod make(final List<String> patterns) {
            ArrayList<String> simplifiedPatterns = new ArrayList<String>();
            for (String pattern : patterns) {
                String simplifiedPattern = pattern.replaceAll("\\?:", "");
                simplifiedPatterns.add(simplifiedPattern);
            }
            MultiPattern multipattern = MultiPattern.of(simplifiedPatterns);
            final MultiPatternSearcher searcher = multipattern.searcher();
            return new PatternMatchingMethod(){

                @Override
                public int[] matchCounts(String txt) {
                    int[] matchCounts = new int[patterns.size()];
                    Arrays.fill(matchCounts, 0);
                    MultiPatternSearcher.Cursor cursor = searcher.search(txt);
                    while (cursor.next()) {
                        int n = cursor.match();
                        matchCounts[n] = matchCounts[n] + 1;
                    }
                    return matchCounts;
                }
            };
        }
    }
    ,
    JAVA{

        @Override
        PatternMatchingMethod make(List<String> patterns) {
            final ArrayList<Pattern> compiledPatterns = new ArrayList<Pattern>();
            for (String pattern : patterns) {
                compiledPatterns.add(Pattern.compile(pattern));
            }
            return new PatternMatchingMethod(){

                private int countPattern(Pattern pattern, String txt) {
                    Matcher matcher = pattern.matcher(txt);
                    int count = 0;
                    while (matcher.find()) {
                        ++count;
                    }
                    return count;
                }

                @Override
                public int[] matchCounts(String txt) {
                    int[] matchCounts = new int[compiledPatterns.size()];
                    int patternId = 0;
                    for (Pattern compiledPattern : compiledPatterns) {
                        matchCounts[patternId] = this.countPattern(compiledPattern, txt);
                        ++patternId;
                    }
                    return matchCounts;
                }
            };
        }
    }
    ,
    DKU{

        @Override
        PatternMatchingMethod make(List<String> patterns) {
            final ArrayList<RunAutomaton> compiledPatterns = new ArrayList<RunAutomaton>();
            for (String pattern : patterns) {
                String simplifiedPattern = pattern.replaceAll("\\?:", "");
                RegExp regexp = new RegExp(simplifiedPattern);
                Automaton automaton = regexp.toAutomaton();
                automaton.determinize();
                RunAutomaton runAutomaton = new RunAutomaton(automaton, true);
                compiledPatterns.add(runAutomaton);
            }
            return new PatternMatchingMethod(){

                private int countPattern(RunAutomaton pattern, String txt) {
                    AutomatonMatcher matcher = pattern.newMatcher((CharSequence)txt);
                    int count = 0;
                    while (matcher.find()) {
                        ++count;
                    }
                    return count;
                }

                @Override
                public int[] matchCounts(String txt) {
                    int[] matchCounts = new int[compiledPatterns.size()];
                    int patternId = 0;
                    for (RunAutomaton compiledPattern : compiledPatterns) {
                        matchCounts[patternId] = this.countPattern(compiledPattern, txt);
                        ++patternId;
                    }
                    return matchCounts;
                }
            };
        }
    };


    abstract PatternMatchingMethod make(List<String> var1);

    public static interface PatternMatchingMethod {
        public int[] matchCounts(String var1);
    }
}

