/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.kit.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.provider.Contacts;
import android.text.TextUtils;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J>\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0017\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u000bJ\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0006J\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0006J\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0006J\u0018\u0010!\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0006H\u0002J\u001a\u0010#\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010$\u001a\u00020\u0012H\u0007J\u000e\u0010%\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010%\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u000bJ\u000e\u0010%\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0006J\u000e\u0010&\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010&\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u000bJ\u000e\u0010&\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0006J\u000e\u0010'\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0006J\u000e\u0010(\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0006J\u0014\u0010)\u001a\u00020\u00042\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u0006H\u0007J\u0006\u0010+\u001a\u00020\u0004J\u0006\u0010,\u001a\u00020\u0004J)\u0010-\u001a\u00020\u00042\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00060/2\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006\u00a2\u0006\u0002\u00102J\u001e\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006J\u0016\u00103\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u0006J\u0016\u00105\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006J%\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u0002082\b\u0010:\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010;J\u0006\u0010<\u001a\u00020\u0004JC\u0010=\u001a\u00020\u00042\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u0002082\b\u0010>\u001a\u0004\u0018\u0001082\b\u0010?\u001a\u0004\u0018\u00010\r2\b\u0010@\u001a\u0004\u0018\u0001082\b\u0010A\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010B\u00a8\u0006C"}, d2={"Lcom/ftinc/kit/util/IntentUtils;", "", "()V", "callPhone", "Landroid/content/Intent;", "phoneNumber", "", "cropImage", "context", "Landroid/content/Context;", "image", "Ljava/io/File;", "outputX", "", "outputY", "aspectX", "aspectY", "scale", "", "dialPhone", "findLocation", "query", "isCropAvailable", "isIntentAvailable", "intent", "openAudio", "uri", "Landroid/net/Uri;", "file", "openImage", "openLink", "url", "Ljava/net/URL;", "openMedia", "mimeType", "openPlayStore", "openInBrowser", "openText", "openVideo", "photoCapture", "pick", "pickContact", "scope", "pickFile", "pickImage", "sendEmail", "to", "", "subject", "text", "([Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Landroid/content/Intent;", "sendSms", "message", "shareText", "showLocation", "latitude", "", "longitude", "zoomLevel", "(FFLjava/lang/Integer;)Landroid/content/Intent;", "showLocationServices", "showStreetView", "yaw", "pitch", "zoom", "mapZoom", "(FFLjava/lang/Float;Ljava/lang/Integer;Ljava/lang/Float;Ljava/lang/Integer;)Landroid/content/Intent;", "kit_release"})
public final class IntentUtils {
    public static final IntentUtils INSTANCE;

    @JvmOverloads
    @NotNull
    public final Intent openPlayStore(@NotNull Context context, boolean openInBrowser) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String appPackageName = context.getPackageName();
        Intent marketIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + appPackageName)));
        if (this.isIntentAvailable(context, marketIntent)) {
            return marketIntent;
        }
        return openInBrowser ? this.openLink("https://play.google.com/store/apps/details?id=" + appPackageName) : marketIntent;
    }

    public static /* synthetic */ Intent openPlayStore$default(IntentUtils intentUtils, Context context, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return intentUtils.openPlayStore(context, bl);
    }

    @JvmOverloads
    @NotNull
    public final Intent openPlayStore(@NotNull Context context) {
        return IntentUtils.openPlayStore$default(this, context, false, 2, null);
    }

    @NotNull
    public final Intent sendEmail(@NotNull String to, @NotNull String subject, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return this.sendEmail(new String[]{to}, subject, text);
    }

    @NotNull
    public final Intent sendEmail(@NotNull String[] to, @NotNull String subject, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("message/rfc822");
        intent.putExtra("android.intent.extra.EMAIL", to);
        intent.putExtra("android.intent.extra.SUBJECT", subject);
        intent.putExtra("android.intent.extra.TEXT", text);
        return intent;
    }

    @NotNull
    public final Intent shareText(@NotNull String subject, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intent intent = new Intent();
        intent.setAction("android.intent.action.SEND");
        if (!TextUtils.isEmpty((CharSequence)subject)) {
            intent.putExtra("android.intent.extra.SUBJECT", subject);
        }
        intent.putExtra("android.intent.extra.TEXT", text);
        intent.setType("text/plain");
        return intent;
    }

    @NotNull
    public final Intent sendSms(@NotNull String to, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Uri smsUri = Uri.parse((String)("tel:" + to));
        Intent intent = new Intent("android.intent.action.VIEW", smsUri);
        intent.putExtra("address", to);
        intent.putExtra("sms_body", message);
        intent.setType("vnd.android-dir/mms-sms");
        return intent;
    }

    @NotNull
    public final Intent showStreetView(float latitude, float longitude, @Nullable Float yaw, @Nullable Integer pitch, @Nullable Float zoom, @Nullable Integer mapZoom) {
        StringBuilder builder = new StringBuilder("google.streetview:cbll=").append(latitude).append(",").append(longitude);
        if (yaw != null || pitch != null || zoom != null) {
            Object object;
            Object object2;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%s,,%s,%s";
            Object[] objectArray = new Object[3];
            Object object3 = yaw;
            if (object3 == null) {
                object3 = objectArray[0] = "";
            }
            if ((object2 = pitch) == null) {
                object2 = objectArray[1] = "";
            }
            if ((object = zoom) == null) {
                object = "";
            }
            objectArray[2] = object;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String cbpParam = string2;
            builder.append("&cbp=1,").append(cbpParam);
        }
        if (mapZoom != null) {
            builder.append("&mz=").append(mapZoom);
        }
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)builder.toString()));
        return intent;
    }

    @NotNull
    public final Intent showLocation(float latitude, float longitude, @Nullable Integer zoomLevel) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "geo:%s,%s";
        Object[] objectArray = new Object[]{Float.valueOf(latitude), Float.valueOf(longitude)};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String data = string2;
        if (zoomLevel != null) {
            stringCompanionObject = StringCompanionObject.INSTANCE;
            string = "%s?z=%s";
            objectArray = new Object[]{data, zoomLevel};
            bl = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            data = string3;
        }
        intent.setData(Uri.parse((String)data));
        return intent;
    }

    @NotNull
    public final Intent findLocation(@NotNull String query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "geo:0,0?q=%s";
        Object[] objectArray = new Object[]{query};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String data = string2;
        intent.setData(Uri.parse((String)data));
        return intent;
    }

    @NotNull
    public final Intent showLocationServices() {
        Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
        intent.addFlags(0x40080000);
        return intent;
    }

    @NotNull
    public final Intent openLink(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String url2 = url;
        if (!TextUtils.isEmpty((CharSequence)url2) && !StringsKt.contains$default((CharSequence)url2, (CharSequence)"://", (boolean)false, (int)2, null)) {
            url2 = "http://" + url2;
        }
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)url2));
        return intent;
    }

    @NotNull
    public final Intent openLink(@NotNull URL url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String string = url.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
        return this.openLink(string);
    }

    @NotNull
    public final Intent openVideo(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Uri uri = Uri.fromFile((File)file);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.fromFile(file)");
        return this.openVideo(uri);
    }

    @NotNull
    public final Intent openVideo(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.openVideo(new File(file));
    }

    @NotNull
    public final Intent openVideo(@NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        return this.openMedia(uri, "video/*");
    }

    @NotNull
    public final Intent openAudio(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Uri uri = Uri.fromFile((File)file);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.fromFile(file)");
        return this.openAudio(uri);
    }

    @NotNull
    public final Intent openAudio(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.openAudio(new File(file));
    }

    @NotNull
    public final Intent openAudio(@NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        return this.openMedia(uri, "audio/*");
    }

    @NotNull
    public final Intent openImage(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.openImage(new File(file));
    }

    @NotNull
    public final Intent openImage(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Uri uri = Uri.fromFile((File)file);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.fromFile(file)");
        return this.openImage(uri);
    }

    @NotNull
    public final Intent openImage(@NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        return this.openMedia(uri, "image/*");
    }

    @NotNull
    public final Intent openText(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.openText(new File(file));
    }

    @NotNull
    public final Intent openText(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Uri uri = Uri.fromFile((File)file);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.fromFile(file)");
        return this.openText(uri);
    }

    @NotNull
    public final Intent openText(@NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        return this.openMedia(uri, "text/plain");
    }

    @NotNull
    public final Intent pickFile() {
        return this.pick("file/*");
    }

    @NotNull
    public final Intent pick(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType(mimeType);
        return intent;
    }

    @NotNull
    public final Intent callPhone(@NotNull String phoneNumber) {
        Intrinsics.checkParameterIsNotNull((Object)phoneNumber, (String)"phoneNumber");
        Intent intent = new Intent();
        intent.setAction("android.intent.action.CALL");
        intent.setData(Uri.parse((String)("tel:" + phoneNumber)));
        return intent;
    }

    @JvmOverloads
    @NotNull
    public final Intent pickContact(@Nullable String scope) {
        Intent intent = null;
        intent = Build.VERSION.SDK_INT < 5 ? new Intent("android.intent.action.PICK", Contacts.People.CONTENT_URI) : new Intent("android.intent.action.PICK", Uri.parse((String)"content://com.android.contacts/contacts"));
        if (!TextUtils.isEmpty((CharSequence)scope)) {
            intent.setType(scope);
        }
        return intent;
    }

    public static /* synthetic */ Intent pickContact$default(IntentUtils intentUtils, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return intentUtils.pickContact(string);
    }

    @JvmOverloads
    @NotNull
    public final Intent pickContact() {
        return IntentUtils.pickContact$default(this, null, 1, null);
    }

    @NotNull
    public final Intent pickImage() {
        Intent intent = new Intent("android.intent.action.PICK");
        intent.setType("image/*");
        return intent;
    }

    @NotNull
    public final Intent dialPhone(@NotNull String phoneNumber) {
        Intrinsics.checkParameterIsNotNull((Object)phoneNumber, (String)"phoneNumber");
        Intent intent = new Intent();
        intent.setAction("android.intent.action.DIAL");
        intent.setData(Uri.parse((String)("tel:" + phoneNumber)));
        return intent;
    }

    public final boolean isCropAvailable(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setType("image/*");
        return INSTANCE.isIntentAvailable(context, intent);
    }

    @NotNull
    public final Intent cropImage(@NotNull Context context, @NotNull File image, int outputX, int outputY, int aspectX, int aspectY, boolean scale) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setType("image/*");
        List list = context.getPackageManager().queryIntentActivities(intent, 0);
        ResolveInfo res = (ResolveInfo)list.get(0);
        intent.putExtra("outputX", outputX);
        intent.putExtra("outputY", outputY);
        intent.putExtra("aspectX", aspectX);
        intent.putExtra("aspectY", aspectY);
        intent.putExtra("scale", scale);
        intent.putExtra("return-data", true);
        intent.setData(Uri.fromFile((File)image));
        intent.setComponent(new ComponentName(res.activityInfo.packageName, res.activityInfo.name));
        return intent;
    }

    @NotNull
    public final Intent photoCapture(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Uri uri = Uri.fromFile((File)new File(file));
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)uri);
        return intent;
    }

    public final boolean isIntentAvailable(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 65536);
        return list.size() > 0;
    }

    private final Intent openMedia(Uri uri, String mimeType) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(uri, mimeType);
        return intent;
    }

    private IntentUtils() {
    }

    static {
        IntentUtils intentUtils;
        INSTANCE = intentUtils = new IntentUtils();
    }
}

