/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.kit.util;

import com.ftinc.kit.util.Stopwatch$Companion$WhenMappings;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0006\u0010\r\u001a\u00020\u0000J\u0006\u0010\u000e\u001a\u00020\u0000J\u0006\u0010\u000f\u001a\u00020\u0000J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/ftinc/kit/util/Stopwatch;", "", "()V", "elapsedNanos", "", "<set-?>", "", "isRunning", "()Z", "startTick", "elapsed", "desiredUnit", "Ljava/util/concurrent/TimeUnit;", "reset", "start", "stop", "toString", "", "Companion", "kit_release"})
public final class Stopwatch {
    private boolean isRunning;
    private long elapsedNanos;
    private long startTick;
    public static final Companion Companion = new Companion(null);

    public final boolean isRunning() {
        return this.isRunning;
    }

    @NotNull
    public final Stopwatch start() {
        this.isRunning = true;
        this.startTick = System.nanoTime();
        return this;
    }

    @NotNull
    public final Stopwatch stop() {
        long tick = System.nanoTime();
        this.isRunning = false;
        this.elapsedNanos += tick - this.startTick;
        return this;
    }

    @NotNull
    public final Stopwatch reset() {
        this.elapsedNanos = 0L;
        this.isRunning = false;
        return this;
    }

    private final long elapsedNanos() {
        return this.isRunning ? System.nanoTime() - this.startTick + this.elapsedNanos : this.elapsedNanos;
    }

    public final long elapsed(@NotNull TimeUnit desiredUnit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)desiredUnit), (String)"desiredUnit");
        return desiredUnit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
    }

    @NotNull
    public String toString() {
        long nanos = this.elapsedNanos();
        TimeUnit unit = Stopwatch.Companion.chooseUnit(nanos);
        double value = (double)nanos / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%.4g %s";
        Object[] objectArray = new Object[]{value, Stopwatch.Companion.abbreviate(unit)};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    private Stopwatch() {
    }

    public /* synthetic */ Stopwatch(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lcom/ftinc/kit/util/Stopwatch$Companion;", "", "()V", "abbreviate", "", "unit", "Ljava/util/concurrent/TimeUnit;", "chooseUnit", "nanos", "", "createStarted", "Lcom/ftinc/kit/util/Stopwatch;", "createUnstarted", "kit_release"})
    public static final class Companion {
        @NotNull
        public final Stopwatch createUnstarted() {
            return new Stopwatch(null);
        }

        @NotNull
        public final Stopwatch createStarted() {
            return new Stopwatch(null).start();
        }

        private final TimeUnit chooseUnit(long nanos) {
            if (TimeUnit.DAYS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
                return TimeUnit.DAYS;
            }
            if (TimeUnit.HOURS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
                return TimeUnit.HOURS;
            }
            if (TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
                return TimeUnit.MINUTES;
            }
            if (TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
                return TimeUnit.SECONDS;
            }
            if (TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
                return TimeUnit.MILLISECONDS;
            }
            return TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L ? TimeUnit.MICROSECONDS : TimeUnit.NANOSECONDS;
        }

        private final String abbreviate(TimeUnit unit) {
            String string;
            switch (Stopwatch$Companion$WhenMappings.$EnumSwitchMapping$0[unit.ordinal()]) {
                case 1: {
                    string = "ns";
                    break;
                }
                case 2: {
                    string = "\u03bcs";
                    break;
                }
                case 3: {
                    string = "ms";
                    break;
                }
                case 4: {
                    string = "s";
                    break;
                }
                case 5: {
                    string = "min";
                    break;
                }
                case 6: {
                    string = "h";
                    break;
                }
                case 7: {
                    string = "d";
                    break;
                }
                default: {
                    throw (Throwable)((Object)new AssertionError());
                }
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

