/*
 * Decompiled with CFR 0.152.
 */
package com.fsryan.tools.logging.android;

import android.os.SystemClock;
import com.fsryan.tools.logging.FSDevMetricsLogger;
import com.microsoft.appcenter.analytics.Analytics;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/fsryan/tools/logging/android/NonFatalDevMetricsLogger;", "Lcom/fsryan/tools/logging/FSDevMetricsLogger;", "()V", "appStartTimeMillis", "", "enabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getEnabled", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "alarm", "", "t", "", "attrs", "", "", "id", "logging-android-appcenter_release"})
public final class NonFatalDevMetricsLogger
implements FSDevMetricsLogger {
    @NotNull
    private final AtomicBoolean enabled = new AtomicBoolean(false);
    private final long appStartTimeMillis = System.currentTimeMillis();

    @NotNull
    public final AtomicBoolean getEnabled() {
        return this.enabled;
    }

    @NotNull
    public String id() {
        return "nonfatal";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(@NotNull Throwable t, @NotNull Map<String, String> attrs) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
        Intrinsics.checkParameterIsNotNull(attrs, (String)"attrs");
        if (!this.enabled.get()) {
            return;
        }
        Closeable closeable = new StringWriter();
        boolean bl = false;
        Throwable throwable = null;
        try {
            StringWriter sw = (StringWriter)closeable;
            boolean bl2 = false;
            Closeable closeable2 = new PrintWriter(sw);
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                PrintWriter pw = (PrintWriter)closeable2;
                boolean bl4 = false;
                t.printStackTrace(pw);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            String string2 = sw.toString();
            string = string2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringWriter().use { sw \u2026  sw.toString()\n        }");
        String stacktrace = string;
        Analytics.trackEvent((String)"nonfatal", (Map)MapsKt.plus(attrs, (Map)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"system_uptime", (Object)String.valueOf(SystemClock.uptimeMillis())), TuplesKt.to((Object)"app_uptime", (Object)String.valueOf(System.currentTimeMillis() - this.appStartTimeMillis)), TuplesKt.to((Object)"exception", (Object)stacktrace)})), (int)2);
    }

    public void info(@NotNull String msg, @Nullable String info, @Nullable String extraInfo, @NotNull Map<String, String> attrs) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Intrinsics.checkParameterIsNotNull(attrs, (String)"attrs");
        FSDevMetricsLogger.DefaultImpls.info((FSDevMetricsLogger)this, (String)msg, (String)info, (String)extraInfo, attrs);
    }

    public void metric(@NotNull String operationName, long durationNanos) {
        Intrinsics.checkParameterIsNotNull((Object)operationName, (String)"operationName");
        FSDevMetricsLogger.DefaultImpls.metric((FSDevMetricsLogger)this, (String)operationName, (long)durationNanos);
    }

    public void watch(@NotNull String msg, @Nullable String info, @Nullable String extraInfo, @NotNull Map<String, String> attrs) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Intrinsics.checkParameterIsNotNull(attrs, (String)"attrs");
        FSDevMetricsLogger.DefaultImpls.watch((FSDevMetricsLogger)this, (String)msg, (String)info, (String)extraInfo, attrs);
    }
}

