/*
 * Decompiled with CFR 0.152.
 */
package com.fsryan.tools.logging.android;

import android.content.Context;
import android.content.res.Resources;
import com.fsryan.tools.logging.android.ContextSpecificEventLogger;
import com.microsoft.appcenter.analytics.Analytics;
import com.microsoft.appcenter.analytics.EventProperties;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J$\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J&\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00052\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/fsryan/tools/logging/android/AppCenterAnalyticsEventLogger;", "Lcom/fsryan/tools/logging/android/ContextSpecificEventLogger;", "()V", "booleanProperties", "", "", "countableAttrs", "", "", "doubleProperties", "longProperties", "userProperties", "addAttr", "", "attrName", "attrValue", "addEvent", "eventName", "attrs", "", "id", "incrementAttrValue", "initialize", "context", "Landroid/content/Context;", "storePropertyNamesInto", "stringArrayName", "dest", "logging-android-appcenter_release"})
public final class AppCenterAnalyticsEventLogger
implements ContextSpecificEventLogger {
    private final Map<String, Long> countableAttrs = new ConcurrentHashMap();
    private final Map<String, String> userProperties = new ConcurrentHashMap();
    private final Set<String> doubleProperties = new CopyOnWriteArraySet();
    private final Set<String> longProperties = new CopyOnWriteArraySet();
    private final Set<String> booleanProperties = new CopyOnWriteArraySet();

    @NotNull
    public String id() {
        return "appcenter";
    }

    public void initialize(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.storePropertyNamesInto(context, "fs_appcenter_double_properties", this.doubleProperties);
        this.storePropertyNamesInto(context, "fs_appcenter_long_properties", this.longProperties);
        this.storePropertyNamesInto(context, "fs_appcenter_boolean_properties", this.booleanProperties);
    }

    public void addAttr(@NotNull String attrName, @NotNull String attrValue) {
        Intrinsics.checkParameterIsNotNull((Object)attrName, (String)"attrName");
        Intrinsics.checkParameterIsNotNull((Object)attrValue, (String)"attrValue");
        this.userProperties.put(attrName, attrValue);
        try {
            String string = attrValue;
            String string2 = attrName;
            Map<String, Long> map = this.countableAttrs;
            boolean bl = false;
            long l = Long.parseLong(string);
            map.put(string2, l);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void incrementAttrValue(@NotNull String attrName) {
        Intrinsics.checkParameterIsNotNull((Object)attrName, (String)"attrName");
        Long l = this.countableAttrs.get(attrName);
        this.addAttr(attrName, String.valueOf((l != null ? l : 0L) + 1L));
    }

    public void addEvent(@NotNull String eventName, @NotNull Map<String, String> attrs) {
        Intrinsics.checkParameterIsNotNull((Object)eventName, (String)"eventName");
        Intrinsics.checkParameterIsNotNull(attrs, (String)"attrs");
        EventProperties eventProperties = new EventProperties();
        String string = eventName;
        boolean bl = false;
        boolean bl2 = false;
        EventProperties $this$apply = eventProperties;
        boolean bl3 = false;
        Map $this$forEach$iv = MapsKt.plus(this.userProperties, attrs);
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl4 = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            EventProperties eventProperties2;
            String string2;
            Map.Entry element$iv;
            Map.Entry $dstr$key$value = element$iv = iterator.next();
            boolean bl5 = false;
            Object object = $dstr$key$value;
            boolean bl6 = false;
            String key = (String)object.getKey();
            object = $dstr$key$value;
            bl6 = false;
            String value = (String)object.getValue();
            if (this.doubleProperties.contains(key)) {
                object = value;
                string2 = key;
                eventProperties2 = $this$apply;
                bl6 = false;
                double d = Double.parseDouble((String)object);
                eventProperties2.set(string2, d);
                continue;
            }
            if (this.longProperties.contains(key)) {
                object = value;
                string2 = key;
                eventProperties2 = $this$apply;
                bl6 = false;
                long l = Long.parseLong((String)object);
                eventProperties2.set(string2, l);
                continue;
            }
            if (this.booleanProperties.contains(key)) {
                object = value;
                string2 = key;
                eventProperties2 = $this$apply;
                bl6 = false;
                boolean bl7 = Boolean.parseBoolean((String)object);
                eventProperties2.set(string2, bl7);
                continue;
            }
            $this$apply.set(key, value);
        }
        EventProperties eventProperties3 = eventProperties;
        Analytics.trackEvent((String)string, (EventProperties)eventProperties3);
    }

    private final void storePropertyNamesInto(Context context, String stringArrayName, Set<String> dest) {
        int arrayRes = context.getResources().getIdentifier(stringArrayName, "array", context.getPackageName());
        if (arrayRes == 0) {
            throw (Throwable)new IllegalStateException("must have string-array resource " + stringArrayName);
        }
        try {
            Collection collection = dest;
            Object[] objectArray = context.getResources().getStringArray(arrayRes);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"context.resources.getStringArray(arrayRes)");
            CollectionsKt.addAll((Collection)collection, (Object[])objectArray);
        }
        catch (Resources.NotFoundException rnfe) {
            throw (Throwable)new IllegalArgumentException("Error finding string-array resource: '" + stringArrayName + "' (" + arrayRes + ')');
        }
    }
}

