/*
 * Decompiled with CFR 0.152.
 */
package com.fredhopper.lifecycle;

import com.fredhopper.lifecycle.LifeCycle;
import com.fredhopper.lifecycle.State;
import com.fredhopper.lifecycle.StateListener;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractLifeCycle
implements LifeCycle {
    private final AtomicReference<State> state = new AtomicReference<State>(State.STOPPED);
    private final Collection<StateListener> stateListeners = new CopyOnWriteArrayList<StateListener>();

    @Override
    public State getState() {
        return this.state.get();
    }

    @Override
    public Collection<StateListener> getStateListeners() {
        return this.stateListeners;
    }

    @Override
    public void initLifeCycle() throws Exception {
        this.doInitLifeCycle();
        this.changeState(State.STOPPED, State.INITIALIZED);
    }

    @Override
    public void startLifeCycle() throws Exception {
        this.changeState(State.INITIALIZED, State.STARTING);
        this.doStartLifeCycle();
        this.changeState(State.STARTING, State.RUNNING);
    }

    @Override
    public void pause() throws Exception {
        this.doPause();
        this.changeState(State.RUNNING, State.PAUSED);
    }

    @Override
    public void resume() throws Exception {
        this.doResume();
        this.changeState(State.PAUSED, State.RUNNING);
    }

    @Override
    public void stopLifeCycle() throws Exception {
        this.changeState(State.RUNNING, State.STOPPING);
        this.doStopLifeCycle();
        this.changeState(State.STOPPING, State.STOPPED);
    }

    public void addStateListener(StateListener listener) {
        this.stateListeners.add(listener);
    }

    public void removeStateListener(StateListener listener) {
        this.stateListeners.remove(listener);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }

    protected void changeState(State from, State to) throws Exception {
        if (!this.state.compareAndSet(from, to)) {
            throw new Exception("Cannot change state from " + (Object)((Object)from) + " to " + (Object)((Object)to) + " for " + this);
        }
        this.publishState(from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishState(State from, State to) throws Exception {
        Collection<StateListener> listeners;
        Collection<StateListener> collection = listeners = this.getStateListeners();
        synchronized (collection) {
            for (StateListener listener : listeners) {
                listener.stateChanged(from, to);
            }
        }
    }

    protected abstract void doInitLifeCycle() throws Exception;

    protected abstract void doStartLifeCycle() throws Exception;

    protected void doPause() throws Exception {
    }

    protected void doResume() throws Exception {
    }

    protected abstract void doStopLifeCycle() throws Exception;
}

