/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.tools;

import com.sforce.ws.bind.NameMapper;
import com.sforce.ws.bind.TypeMapper;
import com.sforce.ws.tools.TypeGenerator;
import com.sforce.ws.wsdl.Collection;
import com.sforce.ws.wsdl.ComplexType;
import com.sforce.ws.wsdl.Element;
import com.sforce.ws.wsdl.Schema;
import com.sforce.ws.wsdl.Types;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class ComplexTypeGenerator
extends TypeGenerator {
    private final ComplexType complexType;
    private final boolean laxMinOccursMode;
    private static final JavaTypeMap javaTypeMap = ComplexTypeGenerator.javaTypeMap();
    private static final String TEMPLATE = "com/sforce/ws/tools/type.template";

    public ComplexTypeGenerator(Types types, Schema schema, ComplexType complexType, File tempDir, TypeMapper typeMapper, boolean laxMinOccursMode) {
        super(types, schema, complexType.getName(), tempDir, typeMapper);
        this.complexType = complexType;
        this.laxMinOccursMode = laxMinOccursMode;
    }

    @Override
    public String getTemplate() {
        return TEMPLATE;
    }

    public String baseClass() {
        StringBuilder sb = new StringBuilder();
        if (this.complexType.getBase() == null) {
            if (this.complexType.isHeader()) {
                sb.append("extends com.sforce.ws.bind.SoapHeaderObject ");
            } else if (this.getClassName().endsWith("Fault")) {
                sb.append("extends com.sforce.ws.SoapFaultException ");
            }
            sb.append("implements com.sforce.ws.bind.XMLizable");
        } else {
            sb.append("extends ").append(this.localJavaType(this.complexType.getBase(), 1, false));
        }
        return sb.toString();
    }

    public String superWrite() {
        if (!this.complexType.hasBaseClass()) {
            return "";
        }
        return "super.writeFields(__out, __typeMapper);";
    }

    public String superToString() {
        if (!this.complexType.hasBaseClass()) {
            return "";
        }
        return "sb.append(super.toString());";
    }

    public String superLoad() {
        if (!this.complexType.hasBaseClass()) {
            return "";
        }
        return "super.loadFields(__in, __typeMapper);";
    }

    public String xsiType() {
        if (this.complexType.getBase() == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("__typeMapper.writeXsiType(__out, \"");
        sb.append(this.complexType.getSchema().getTargetNamespace());
        sb.append("\", \"");
        sb.append(this.complexType.getName());
        sb.append("\");");
        return sb.toString();
    }

    public Iterator<Element> getElements() {
        Collection sequence = this.complexType.getContent();
        Iterator<Object> it = sequence == null ? Collections.emptyList().iterator() : sequence.getElements();
        return it;
    }

    public String getMethod(Element element) {
        return "get" + NameMapper.getMethodName(element.getName());
    }

    public String booleanGetMethod(Element element) {
        return "is" + NameMapper.getMethodName(element.getName());
    }

    public String setMethod(Element element) {
        return "set" + NameMapper.getMethodName(element.getName());
    }

    public String elementDoc(Element element) {
        return element.getName() + " of type " + element.getType();
    }

    public String javaType(Element element) {
        QName type = element.getType();
        return this.localJavaType(type, element.getMaxOccurs(), element.isNillable());
    }

    private String localJavaType(QName type, int maxOccurs, boolean nillable) {
        String name = this.mapper.getJavaClassName(type, this.types, nillable);
        if (this.isArray(maxOccurs)) {
            name = name + "[]";
        }
        return name;
    }

    private boolean isArray(int maxOccurs) {
        return maxOccurs == -1 || maxOccurs > 1;
    }

    public String initArray(Element element) {
        StringBuilder sb = new StringBuilder();
        if (this.isArray(element.getMaxOccurs())) {
            sb.append(" = new ");
            sb.append(this.mapper.getJavaClassName(element.getType(), this.types, element.isNillable()));
            sb.append("[0]");
        }
        return sb.toString();
    }

    public String fieldName(Element element) {
        return NameMapper.getFieldName(element.getName());
    }

    public String typeInfo(Element element) {
        String tns = element.getSchema().getTargetNamespace();
        String name = element.getName();
        String typeNs = element.getType().getNamespaceURI();
        String type = element.getType().getLocalPart();
        int minOcc = element.getMinOccurs();
        int maxOcc = element.getMaxOccurs();
        boolean formQualified = element.getSchema().isElementFormQualified();
        return "\"" + tns + "\",\"" + name + "\",\"" + typeNs + "\",\"" + type + "\"," + minOcc + "," + maxOcc + "," + formQualified;
    }

    public String writeMethod(Element element) {
        String type = this.javaType(element);
        JavaType javaType = javaTypeMap.get(type);
        return javaType.writeMethod;
    }

    public String loadType(Element element) {
        if (!this.laxMinOccursMode && element.getMinOccurs() == 1) {
            return "verifyElement";
        }
        return "isElement";
    }

    public String loadMethod(Element element) {
        String type = this.javaType(element);
        JavaType javaType = javaTypeMap.get(type);
        return javaType.loadMethod;
    }

    private static JavaTypeMap javaTypeMap() {
        JavaTypeMap map = new JavaTypeMap();
        map.put("java.lang.String", new JavaType("readString", "writeString"));
        map.put("int", new JavaType("readInt", "writeInt"));
        map.put("boolean", new JavaType("readBoolean", "writeBoolean"));
        map.put("double", new JavaType("readDouble", "writeDouble"));
        map.put("long", new JavaType("readLong", "writeLong"));
        map.put("float", new JavaType("readFloat", "writeFloat"));
        return map;
    }

    private static class JavaType {
        String loadMethod;
        String writeMethod;

        public JavaType(String loadMethod, String writeMethod) {
            this.loadMethod = loadMethod;
            this.writeMethod = writeMethod;
        }
    }

    private static class JavaTypeMap {
        private HashMap<String, JavaType> map = new HashMap();
        private JavaType defaultType = new JavaType("readObject", "writeObject");

        private JavaTypeMap() {
        }

        public JavaType get(String key) {
            JavaType o = this.map.get(key);
            if (o == null) {
                o = this.defaultType;
            }
            return o;
        }

        public void put(String s, JavaType javaType) {
            this.map.put(s, javaType);
        }
    }
}

