/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.rest.tools;

import com.sforce.rest.DescribeLayout;
import com.sforce.rest.DescribeSobject;
import com.sforce.rest.tools.CodeGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class PojoCodeGenerator
extends CodeGenerator {
    private static final String fileExtension = ".java";

    @Override
    boolean generateCode(DescribeSobject.SobjectDescribe sobject, DescribeLayout describe, String packageName) throws IOException {
        String fieldNameLower;
        String fieldNameUpper;
        String fieldNameLower2;
        String baseFolder;
        File outputFolder;
        if (describe == null || sobject == null) {
            return false;
        }
        if (packageName == null || packageName.isEmpty()) {
            packageName = "com.sforce.rest.pojo";
        }
        if (!(outputFolder = new File(baseFolder = packageName.replace(".", "/"))).exists()) {
            outputFolder.mkdirs();
        }
        String parentClass = "SObject";
        String parentClassFQName = packageName + "." + "SObject";
        File parentFile = new File(parentClassFQName.replace(".", "/") + fileExtension);
        if (!parentFile.exists()) {
            this.generateParentClass(parentFile, "SObject", packageName);
        }
        String className = describe.getName();
        File file = new File(baseFolder + "/" + className + fileExtension);
        if (file.exists()) {
            System.out.println("Could not generate code for " + className + "! File exists. Please move or delete.");
            return false;
        }
        if (!file.createNewFile()) {
            return false;
        }
        System.out.println("Generating Java code for " + className);
        FileWriter writer = new FileWriter(file);
        writer.append("package " + packageName + ";" + "\r\n" + "\r\n");
        writer.append("/**\r\n");
        writer.append(" * Generated from information gathered from /services/data/v21.0/sobjects/" + className + "/describe" + "\r\n");
        writer.append(" * @author " + System.getProperty("user.name") + "\r\n");
        writer.append(" * @since 172\r\n");
        writer.append(" */\r\n");
        writer.append("public class " + className + " extends " + "SObject" + " {" + "\r\n");
        writer.append("\tpublic static boolean CREATEABLE = ");
        writer.append(sobject.isCreateable() != false ? "true;" : "false;");
        writer.append("\r\n");
        writer.append("\tpublic static boolean DELETABLE = ");
        writer.append(sobject.isDeletable() != false ? "true;" : "false;");
        writer.append("\r\n");
        writer.append("\tpublic static boolean UPDATEABLE = ");
        writer.append(sobject.isUpdateable() != false ? "true;" : "false;");
        writer.append("\r\n");
        writer.append("\r\n");
        for (DescribeLayout.Field field : describe.getAllFields()) {
            String fieldNameLower3 = field.getName().substring(0, 1).toLowerCase() + field.getName().substring(1, field.getName().length());
            writer.append("\tprivate " + this.getJavaType(field) + " " + fieldNameLower3 + ";" + "\r\n");
        }
        writer.append("\r\n\t/**\r\n");
        writer.append("\t * Constructor.\r\n");
        writer.append("\t */\r\n");
        writer.append("\tpublic " + className + "() { }" + "\r\n");
        int count = 0;
        int max = describe.getRequiredFieldsForCreateUpdate().size();
        if (max > count) {
            writer.append("\r\n\t/**\r\n");
            writer.append("\t * Constructor with required fields.\r\n");
            writer.append("\t */\r\n");
            writer.append("\tpublic " + className + "(");
            for (DescribeLayout.Field field : describe.getRequiredFieldsForCreateUpdate()) {
                fieldNameLower2 = field.getName().substring(0, 1).toLowerCase() + field.getName().substring(1, field.getName().length());
                writer.append(this.getJavaType(field) + " " + fieldNameLower2);
                if (++count == max) continue;
                writer.append(", ");
            }
            writer.append(") {\r\n");
            for (DescribeLayout.Field field : describe.getRequiredFieldsForCreateUpdate()) {
                fieldNameLower2 = field.getName().substring(0, 1).toLowerCase() + field.getName().substring(1, field.getName().length());
                writer.append("\t\tthis." + fieldNameLower2 + " = " + fieldNameLower2 + ";" + "\r\n");
            }
            writer.append("\t}\r\n\r\n");
        }
        for (DescribeLayout.Field field : describe.getAllFields()) {
            fieldNameLower2 = field.getName().substring(0, 1).toLowerCase() + field.getName().substring(1, field.getName().length());
            writer.append("\tpublic " + this.getJavaType(field) + " get" + field.getName() + "() {" + "\r\n");
            writer.append("\t\treturn " + fieldNameLower2 + ";" + "\r\n");
            writer.append("\t}\r\n");
        }
        for (DescribeLayout.Field field : describe.getRequiredFieldsForCreateUpdate()) {
            fieldNameUpper = field.getName();
            fieldNameLower = field.getName().substring(0, 1).toLowerCase() + field.getName().substring(1, field.getName().length());
            writer.append("\t/**\r\n");
            writer.append("\t * " + fieldNameUpper + " is a required field." + "\r\n");
            writer.append("\t */\r\n");
            writer.append("\tpublic void setRequired" + fieldNameUpper + "(" + this.getJavaType(field) + " " + fieldNameLower + ") {" + "\r\n");
            writer.append("\t\tthis." + fieldNameLower + " = " + fieldNameLower + ";" + "\r\n");
            writer.append("\t}\r\n");
        }
        for (DescribeLayout.Field field : describe.getOptionalFieldsForCreateUpdate()) {
            fieldNameUpper = field.getName();
            fieldNameLower = field.getName().substring(0, 1).toLowerCase() + field.getName().substring(1, field.getName().length());
            writer.append("\t/**\r\n");
            writer.append("\t * " + fieldNameUpper + " is an optional field." + "\r\n");
            writer.append("\t */\r\n");
            writer.append("\tpublic void setOptional" + fieldNameUpper + "(" + this.getJavaType(field) + " " + fieldNameLower + ") {" + "\r\n");
            writer.append("\t\tthis." + fieldNameLower + " = " + fieldNameLower + ";" + "\r\n");
            writer.append("\t}\r\n\r\n");
        }
        writer.append("}\r\n");
        writer.close();
        return true;
    }

    private boolean generateParentClass(File file, String className, String packageName) throws IOException {
        if (!file.createNewFile()) {
            return false;
        }
        FileWriter writer = new FileWriter(file);
        writer.append("package " + packageName + ";" + "\r\n" + "\r\n");
        writer.append("/**\r\n");
        writer.append(" * Parent class.\r\n");
        writer.append(" * @author " + System.getProperty("user.name") + "\r\n");
        writer.append(" * @since 172\r\n");
        writer.append(" */\r\n");
        writer.append("public abstract class " + className + " {" + "\r\n" + "\r\n" + "}" + "\r\n");
        writer.close();
        System.out.println("Wrote parent class " + className + fileExtension);
        return true;
    }

    private String getJavaType(DescribeLayout.Field field) {
        if (field.getType().equals("int")) {
            return "Integer";
        }
        if (field.getType().equals("boolean")) {
            return "Boolean";
        }
        if (field.getType().equals("double")) {
            return "Double";
        }
        return "String";
    }
}

