/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.rest.tools;

import com.sforce.rest.DescribeLayout;
import com.sforce.rest.DescribeSobject;
import com.sforce.rest.tools.CodeGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class DotNetCodeGenerator
extends CodeGenerator {
    @Override
    boolean generateCode(DescribeSobject.SobjectDescribe sobject, DescribeLayout describe, String namespace) throws IOException {
        String baseFolder;
        File outputFolder;
        if (describe == null || sobject == null) {
            return false;
        }
        if (namespace == null || namespace.isEmpty()) {
            namespace = "Sforce.Sobjects";
        }
        if (!(outputFolder = new File(baseFolder = namespace.replace(".", "/"))).exists()) {
            outputFolder.mkdirs();
        }
        String className = describe.getName();
        File file = new File(baseFolder + "/" + className + ".cs");
        if (file.exists()) {
            System.out.println("Could not generate code for " + className + "! File exists. Please move or delete.");
            return false;
        }
        file.createNewFile();
        System.out.println("Generating C# .NET code for " + className);
        FileWriter writer = new FileWriter(file);
        writer.append("using System;\r\n\r\n");
        writer.append("namespace " + namespace + "\r\n");
        writer.append("{\r\n");
        writer.append("\t/// <summary>\r\n");
        writer.append("\t/// Generated from information gathered from /services/data/v21");
        writer.append(".0/sobjects/" + className + "/describe by " + System.getProperty("user.name") + "\r\n");
        writer.append("\t/// </summary>\r\n");
        writer.append("\tpublic class " + className + "\r\n");
        writer.append("\t{\r\n");
        writer.append("\t\tconst bool createable = ");
        writer.append(sobject.isCreateable() != false ? "true;" : "false;");
        writer.append("\r\n");
        writer.append("\t\tconst bool deletable = ");
        writer.append(sobject.isDeletable() != false ? "true;" : "false;");
        writer.append("\r\n");
        writer.append("\t\tconst bool updateable = ");
        writer.append(sobject.isUpdateable() != false ? "true;" : "false;");
        writer.append("\r\n");
        writer.append("\r\n");
        for (DescribeLayout.Field field : describe.getAllFields()) {
            String fieldNameLower = field.getName().substring(0, 1).toLowerCase() + field.getName().substring(1, field.getName().length());
            writer.append("\t\tpublic " + this.getDotNetType(field) + " " + fieldNameLower);
            if (field.isUpdateable().booleanValue() || field.isCreateable().booleanValue()) {
                writer.append(" {get; set;}");
                if (describe.getRequiredFieldsForCreateUpdate().contains(field)) {
                    writer.append(" //required");
                } else if (describe.getRequiredFieldsForCreateUpdate().contains(field)) {
                    writer.append(" //optional");
                }
                writer.append("\r\n");
                continue;
            }
            writer.append(" {get;}\r\n");
        }
        writer.append("\r\n");
        writer.append("\t\tpublic " + className + "()" + "\r\n");
        writer.append("\t\t{\r\n");
        writer.append("\r\n");
        writer.append("\t\t}\r\n");
        writer.append("\r\n");
        int count = 0;
        int max = describe.getRequiredFieldsForCreateUpdate().size();
        if (max > count) {
            String fieldNameLower;
            writer.append("\t\tpublic " + className + "(");
            for (DescribeLayout.Field field : describe.getRequiredFieldsForCreateUpdate()) {
                fieldNameLower = field.getName().substring(0, 1).toLowerCase() + field.getName().substring(1, field.getName().length());
                writer.append(this.getDotNetType(field) + " " + fieldNameLower);
                if (++count == max) continue;
                writer.append(", ");
            }
            writer.append(")\r\n");
            writer.append("\t\t{\r\n");
            for (DescribeLayout.Field field : describe.getRequiredFieldsForCreateUpdate()) {
                fieldNameLower = field.getName().substring(0, 1).toLowerCase() + field.getName().substring(1, field.getName().length());
                writer.append("\t\t\tthis." + fieldNameLower + " = " + fieldNameLower + ";" + "\r\n");
            }
            writer.append("\t\t}\r\n");
        }
        writer.append("\t}\r\n");
        writer.append("}\r\n");
        writer.close();
        return true;
    }

    private String getDotNetType(DescribeLayout.Field field) {
        if (field.getType().equals("int")) {
            return "int";
        }
        if (field.getType().equals("boolean")) {
            return "bool";
        }
        if (field.getType().equals("double")) {
            return "double";
        }
        return "string";
    }
}

