/*
 * Decompiled with CFR 0.152.
 */
package com.fooock.lib.phone.tracker;

import android.annotation.TargetApi;
import android.content.Context;
import android.location.Location;
import android.net.wifi.ScanResult;
import android.support.annotation.NonNull;
import android.telephony.CellInfo;
import android.telephony.NeighboringCellInfo;
import android.util.Log;
import com.fooock.lib.phone.tracker.CellReceiver;
import com.fooock.lib.phone.tracker.CheckPermission;
import com.fooock.lib.phone.tracker.CheckVersion;
import com.fooock.lib.phone.tracker.Configuration;
import com.fooock.lib.phone.tracker.GpsReceiver;
import com.fooock.lib.phone.tracker.WifiReceiver;
import java.util.ArrayList;
import java.util.List;

public final class PhoneTracker {
    private static final String TAG = PhoneTracker.class.getSimpleName();
    static final String[] LOCATION_PERMISSIONS = new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"};
    static final String[] WIFI_PERMISSIONS = new String[]{"android.permission.CHANGE_WIFI_STATE"};
    private final Context context;
    private final List<PermissionListener> permissionListeners = new ArrayList<PermissionListener>();
    private final CheckVersion checkVersion = new CheckVersion();
    private final CheckPermission checkPermission;
    private final Object lock = new Object();
    private boolean running;
    private WifiReceiver wifiReceiver;
    private CellReceiver cellReceiver;
    private GpsReceiver gpsReceiver;
    private Configuration configuration;
    private ConfigurationChangeListener configurationChangeListener;
    private CellScanListener cellScanListener;
    private WifiScanListener wifiScanListener;
    private GpsLocationListener gpsLocationListener;

    public PhoneTracker(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context can't be null");
        }
        this.context = context;
        this.checkPermission = new CheckPermission(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.running) {
                Log.d((String)TAG, (String)"Tracker is running now...");
                return;
            }
        }
        if (this.configuration == null) {
            this.configuration = new Configuration.Builder().create();
        }
        boolean equalOrGreaterM = this.checkVersion.isEqualOrGreater(23);
        boolean usingWifi = this.configuration.usingWifi();
        boolean usingGps = this.configuration.usingGps();
        boolean usingCell = this.configuration.usingCell();
        if (usingWifi && equalOrGreaterM && !this.checkPermission.hasAnyPermission(LOCATION_PERMISSIONS) && !this.checkPermission.hasPermissions(WIFI_PERMISSIONS)) {
            this.notifyPermissionsNotGranted(LOCATION_PERMISSIONS);
            return;
        }
        if (usingGps && equalOrGreaterM && !this.checkPermission.hasAnyPermission(LOCATION_PERMISSIONS)) {
            this.notifyPermissionsNotGranted(LOCATION_PERMISSIONS);
            return;
        }
        if (usingCell && equalOrGreaterM && !this.checkPermission.hasAnyPermission(LOCATION_PERMISSIONS)) {
            this.notifyPermissionsNotGranted(LOCATION_PERMISSIONS);
            return;
        }
        if (usingWifi) {
            this.wifiReceiver = new WifiReceiver(this.context, this.configuration.wifiConfiguration(), this.wifiScanListener);
            this.wifiReceiver.register();
        }
        if (usingCell) {
            this.cellReceiver = new CellReceiver(this.context, this.configuration.cellConfiguration(), this.cellScanListener);
            this.cellReceiver.register();
        }
        if (usingGps) {
            this.gpsReceiver = new GpsReceiver(this.context, this.configuration.gpsConfiguration(), this.gpsLocationListener);
            this.gpsReceiver.register();
        }
        Object object2 = this.lock;
        synchronized (object2) {
            this.running = true;
        }
        Log.d((String)TAG, (String)"Starting now...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                Log.w((String)TAG, (String)"Not running, can't stop ;-)");
                return;
            }
        }
        if (this.wifiReceiver != null) {
            this.wifiReceiver.unregister();
        }
        if (this.cellReceiver != null) {
            this.cellReceiver.unregister();
        }
        if (this.gpsReceiver != null) {
            this.gpsReceiver.unregister();
        }
        this.removePermissionListener();
        Log.d((String)TAG, (String)"Stopped tracker");
        object = this.lock;
        synchronized (object) {
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPermissionListener(PermissionListener listener) {
        List<PermissionListener> list = this.permissionListeners;
        synchronized (list) {
            this.permissionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePermissionListener() {
        List<PermissionListener> list = this.permissionListeners;
        synchronized (list) {
            this.permissionListeners.clear();
        }
    }

    public void setConfiguration(@NonNull Configuration configuration) {
        this.configuration = configuration;
    }

    private void notifyPermissionsNotGranted(String ... permissions) {
        if (this.permissionListeners.isEmpty()) {
            return;
        }
        for (PermissionListener permissionListener : this.permissionListeners) {
            permissionListener.onPermissionNotGranted(permissions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lock;
        synchronized (object) {
            return this.running;
        }
    }

    public void updateConfiguration(@NonNull Configuration conf) {
        if (!this.isRunning()) {
            this.setConfiguration(this.configuration);
            return;
        }
        if (!this.configuration.usingWifi() && conf.usingWifi()) {
            this.wifiReceiver = new WifiReceiver(this.context, conf.wifiConfiguration(), this.wifiScanListener);
            this.wifiReceiver.register();
        } else if (this.configuration.usingWifi() && !conf.usingWifi()) {
            this.wifiReceiver.unregister();
            this.wifiReceiver = null;
        } else if (this.configuration.usingWifi() && conf.usingWifi()) {
            this.wifiReceiver.reloadConfiguration(conf.wifiConfiguration());
        }
        if (!this.configuration.usingGps() && conf.usingGps()) {
            this.gpsReceiver = new GpsReceiver(this.context, conf.gpsConfiguration(), this.gpsLocationListener);
            this.gpsReceiver.register();
        } else if (this.configuration.usingGps() && !conf.usingGps()) {
            this.gpsReceiver.unregister();
            this.gpsReceiver = null;
        } else if (this.configuration.usingGps() && conf.usingGps()) {
            this.gpsReceiver.reloadConfiguration(conf.gpsConfiguration());
        }
        if (!this.configuration.usingCell() && conf.usingCell()) {
            this.cellReceiver = new CellReceiver(this.context, conf.cellConfiguration(), this.cellScanListener);
            this.cellReceiver.register();
        } else if (this.configuration.usingCell() && !conf.usingCell()) {
            this.cellReceiver.unregister();
            this.cellReceiver = null;
        } else if (this.configuration.usingCell() && conf.usingCell()) {
            this.cellReceiver.reloadConfiguration(conf.cellConfiguration());
        }
        this.setConfiguration(conf);
        if (this.configurationChangeListener == null) {
            return;
        }
        this.configurationChangeListener.onConfigurationChange(conf);
    }

    public void setConfigurationChangeListener(ConfigurationChangeListener listener) {
        this.configurationChangeListener = listener;
    }

    public void setCellScanListener(CellScanListener cellScanListener) {
        this.cellScanListener = cellScanListener;
    }

    public void setWifiScanListener(WifiScanListener wifiScanListener) {
        this.wifiScanListener = wifiScanListener;
    }

    public void setGpsLocationListener(GpsLocationListener gpsLocationListener) {
        this.gpsLocationListener = gpsLocationListener;
    }

    public static interface GpsLocationListener {
        public void onLocationReceived(long var1, Location var3);
    }

    public static interface WifiScanListener {
        public void onWifiScansReceived(long var1, List<ScanResult> var3);
    }

    public static abstract class CellScanAdapter
    implements CellScanListener {
        @Override
        public void onCellInfoReceived(long timestamp, List<CellInfo> cells) {
        }

        @Override
        public void onNeighborCellReceived(long timestamp, List<NeighboringCellInfo> cells) {
        }
    }

    public static interface CellScanListener {
        @TargetApi(value=17)
        public void onCellInfoReceived(long var1, List<CellInfo> var3);

        @TargetApi(value=15)
        public void onNeighborCellReceived(long var1, List<NeighboringCellInfo> var3);
    }

    public static interface ConfigurationChangeListener {
        public void onConfigurationChange(Configuration var1);
    }

    public static interface PermissionListener {
        public void onPermissionNotGranted(String ... var1);
    }
}

