/*
 * Decompiled with CFR 0.152.
 */
package com.fooock.lib.phone.tracker;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.util.Log;
import com.fooock.lib.phone.tracker.CheckPermission;
import com.fooock.lib.phone.tracker.CheckVersion;
import com.fooock.lib.phone.tracker.Configuration;
import com.fooock.lib.phone.tracker.EnvironmentReceiver;
import com.fooock.lib.phone.tracker.PhoneTracker;
import java.util.List;

class WifiReceiver
implements EnvironmentReceiver<Configuration.Wifi> {
    private static final String TAG = WifiReceiver.class.getSimpleName();
    private final Context context;
    private final PhoneTracker.WifiScanListener wifiScanListener;
    private final Handler handler = new Handler();
    private final CheckVersion checkVersion = new CheckVersion();
    private final CheckPermission checkPermission;
    private final WifiManager wifiManager;
    private Configuration.Wifi wifiConfiguration;
    private final BroadcastReceiver wifiReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (WifiReceiver.this.wifiScanListener == null) {
                return;
            }
            List scanResults = WifiReceiver.this.wifiManager.getScanResults();
            long timestamp = System.currentTimeMillis();
            WifiReceiver.this.wifiScanListener.onWifiScansReceived(timestamp, scanResults);
        }
    };

    WifiReceiver(Context context, Configuration.Wifi wifiConfiguration, PhoneTracker.WifiScanListener wifiScanListener) {
        this.context = context;
        this.wifiConfiguration = wifiConfiguration;
        this.wifiScanListener = wifiScanListener;
        this.checkPermission = new CheckPermission(context);
        this.wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
    }

    @Override
    public void register() {
        Log.d((String)TAG, (String)"Registered wifi receiver...");
        this.context.registerReceiver(this.wifiReceiver, new IntentFilter("android.net.wifi.SCAN_RESULTS"));
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                boolean androidMOrGreater = WifiReceiver.this.checkVersion.isEqualOrGreater(23);
                boolean wifiEnabled = WifiReceiver.this.checkPermission.hasPermissions(PhoneTracker.WIFI_PERMISSIONS);
                boolean locationEnabled = WifiReceiver.this.checkPermission.hasAnyPermission(PhoneTracker.LOCATION_PERMISSIONS);
                if (androidMOrGreater && !locationEnabled) {
                    Log.w((String)TAG, (String)"Location permissions not granted to scan wifi in android >= 6.0");
                    WifiReceiver.this.handler.postDelayed((Runnable)this, (long)WifiReceiver.this.wifiConfiguration.getScanDelay());
                    return;
                }
                if (wifiEnabled) {
                    Log.d((String)TAG, (String)("Scanning wifi every " + WifiReceiver.this.wifiConfiguration.getScanDelay() + "ms"));
                    WifiReceiver.this.wifiManager.startScan();
                }
                WifiReceiver.this.handler.postDelayed((Runnable)this, (long)WifiReceiver.this.wifiConfiguration.getScanDelay());
            }
        });
    }

    @Override
    public void unregister() {
        Log.d((String)TAG, (String)"Unregistered wifi receiver...");
        this.handler.removeCallbacksAndMessages(null);
        this.context.unregisterReceiver(this.wifiReceiver);
    }

    @Override
    public void reloadConfiguration(Configuration.Wifi config) {
        if (this.wifiConfiguration.equals(config)) {
            Log.i((String)TAG, (String)"Wifi config is the same, not reload...");
            return;
        }
        Log.d((String)TAG, (String)"Reloading wifi configuration");
        this.wifiConfiguration = config;
    }
}

