/*
 * Decompiled with CFR 0.152.
 */
package com.flyco.dialog.widget.popup;

import android.content.Context;
import android.view.View;
import android.widget.LinearLayout;
import com.flyco.dialog.R;
import com.flyco.dialog.utils.StatusBarUtils;
import com.flyco.dialog.widget.internal.InternalBasePopup;
import com.nineoldandroids.view.ViewHelper;

public abstract class BasePopup<T extends BasePopup<T>>
extends InternalBasePopup<T> {
    protected View mWrappedView = this.onCreatePopupView();
    protected LinearLayout mLlContent;
    protected boolean mAlignCenter;

    public BasePopup(Context context) {
        super(context);
        this.gravity(80);
    }

    public abstract View onCreatePopupView();

    @Override
    public View onCreateView() {
        View inflate = View.inflate((Context)this.mContext, (int)R.layout.popup_base, null);
        this.mLlContent = (LinearLayout)inflate.findViewById(R.id.ll_content);
        this.mLlContent.addView(this.mWrappedView);
        return inflate;
    }

    public T offset(float xOffset, float yOffset) {
        this.mXOffset = xOffset;
        this.mYOffset = yOffset;
        return (T)((Object)this);
    }

    public T alignCenter(boolean alignCenter) {
        this.mAlignCenter = alignCenter;
        return (T)((Object)this);
    }

    @Override
    public T anchorView(View anchorView) {
        if (anchorView != null) {
            this.mAnchorView = anchorView;
            int[] location = new int[2];
            this.mAnchorView.getLocationOnScreen(location);
            this.mX = location[0];
            this.mY = this.mGravity == 48 ? location[1] - StatusBarUtils.getHeight(this.mContext) : location[1] - StatusBarUtils.getHeight(this.mContext) + anchorView.getHeight();
        }
        return (T)((Object)this);
    }

    @Override
    public void onLayoutObtain() {
        int x = this.mX;
        int y = this.mY;
        if (this.mGravity == 48) {
            y = this.mY - this.mLlContent.getHeight();
        }
        if (this.mAlignCenter) {
            x = this.mX + this.mAnchorView.getWidth() / 2 - this.mLlContent.getWidth() / 2;
        }
        x = this.getX(x);
        y = this.getY(y);
        x = this.getX(x + this.dp2px(this.mXOffset));
        y = this.getY(y + this.dp2px(this.mYOffset));
        ViewHelper.setX((View)this.mLlContent, (float)x);
        ViewHelper.setY((View)this.mLlContent, (float)y);
    }

    private int getX(int x) {
        if (x < 0) {
            x = 0;
        }
        if (x + this.mLlContent.getWidth() > this.mDisplayMetrics.widthPixels) {
            x = this.mDisplayMetrics.widthPixels - this.mLlContent.getWidth();
        }
        return x;
    }

    private int getY(int y) {
        if (y < 0) {
            y = 0;
        }
        if ((float)(y + this.mLlContent.getHeight()) > this.mMaxHeight) {
            y = (int)(this.mMaxHeight - (float)this.mLlContent.getHeight());
        }
        return y;
    }
}

