/*
 * Decompiled with CFR 0.152.
 */
package com.flyco.dialog.widget.internal;

import android.content.Context;
import android.view.View;
import android.view.ViewTreeObserver;
import com.flyco.dialog.utils.StatusBarUtils;
import com.flyco.dialog.widget.base.BaseDialog;

public abstract class InternalBasePopup<T extends InternalBasePopup<T>>
extends BaseDialog<T> {
    protected View mAnchorView;
    protected int mX;
    protected int mY;
    protected int mGravity;
    protected float mXOffset;
    protected float mYOffset;
    protected boolean isLayoutObtain;

    public InternalBasePopup(Context context) {
        super(context);
        this.heightScale(1.0f);
        this.dimEnabled(false);
    }

    @Override
    public void onViewCreated(View inflate) {
        this.mLlControlHeight.setClipChildren(false);
        if (inflate != null) {
            inflate.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    InternalBasePopup.this.isLayoutObtain = true;
                    InternalBasePopup.this.onLayoutObtain();
                }
            });
        }
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isLayoutObtain) {
            this.onLayoutObtain();
        }
    }

    public abstract void onLayoutObtain();

    public abstract T anchorView(View var1);

    public T gravity(int gravity) {
        if (gravity != 48 && gravity != 80) {
            throw new IllegalArgumentException("Gravity must be either Gravity.TOP or Gravity.BOTTOM");
        }
        this.mGravity = gravity;
        this.anchorView(this.mAnchorView);
        return (T)((Object)this);
    }

    public T location(int x, int y) {
        this.mX = x;
        this.mY = y - StatusBarUtils.getHeight(this.mContext);
        return (T)((Object)this);
    }
}

