/*
 * Decompiled with CFR 0.152.
 */
package com.flyco.dialog.widget.base;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import com.flyco.animation.BaseAnimatorSet;
import com.flyco.dialog.widget.base.BaseDialog;

public abstract class BottomTopBaseDialog<T extends BottomTopBaseDialog<T>>
extends BaseDialog<T> {
    protected View mAnimateView;
    private BaseAnimatorSet mWindowInAs;
    private BaseAnimatorSet mWindowOutAs;
    protected Animation mInnerShowAnim;
    protected Animation mInnerDismissAnim;
    protected long mInnerAnimDuration = 350L;
    protected boolean mIsInnerShowAnim;
    protected boolean mIsInnerDismissAnim;
    protected int mLeft;
    protected int mTop;
    protected int mRight;
    protected int mBottom;

    public BottomTopBaseDialog(Context context) {
        super(context);
    }

    public T innerAnimDuration(long innerAnimDuration) {
        this.mInnerAnimDuration = innerAnimDuration;
        return (T)((Object)this);
    }

    public T padding(int left, int top, int right, int bottom) {
        this.mLeft = left;
        this.mTop = top;
        this.mRight = right;
        this.mBottom = bottom;
        return (T)((Object)this);
    }

    protected void showWithAnim() {
        if (this.mInnerShowAnim != null) {
            this.mInnerShowAnim.setDuration(this.mInnerAnimDuration);
            this.mInnerShowAnim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    BottomTopBaseDialog.this.mIsInnerShowAnim = true;
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    BottomTopBaseDialog.this.mIsInnerShowAnim = false;
                }
            });
            this.mLlControlHeight.startAnimation(this.mInnerShowAnim);
        }
        if (this.mAnimateView != null) {
            if (this.getWindowInAs() != null) {
                this.mWindowInAs = this.getWindowInAs();
            }
            this.mWindowInAs.duration(this.mInnerAnimDuration).playOn(this.mAnimateView);
        }
    }

    protected void dismissWithAnim() {
        if (this.mInnerDismissAnim != null) {
            this.mInnerDismissAnim.setDuration(this.mInnerAnimDuration);
            this.mInnerDismissAnim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    BottomTopBaseDialog.this.mIsInnerDismissAnim = true;
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    BottomTopBaseDialog.this.mIsInnerDismissAnim = false;
                    BottomTopBaseDialog.this.superDismiss();
                }
            });
            this.mLlControlHeight.startAnimation(this.mInnerDismissAnim);
        } else {
            this.superDismiss();
        }
        if (this.mAnimateView != null) {
            if (this.getWindowOutAs() != null) {
                this.mWindowOutAs = this.getWindowOutAs();
            }
            this.mWindowOutAs.duration(this.mInnerAnimDuration).playOn(this.mAnimateView);
        }
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.mIsInnerDismissAnim || this.mIsInnerShowAnim) {
            return true;
        }
        return super.dispatchTouchEvent(ev);
    }

    @Override
    public void onBackPressed() {
        if (this.mIsInnerDismissAnim || this.mIsInnerShowAnim) {
            return;
        }
        super.onBackPressed();
    }

    protected abstract BaseAnimatorSet getWindowInAs();

    protected abstract BaseAnimatorSet getWindowOutAs();
}

