/*
 * Decompiled with CFR 0.152.
 */
package com.flyco.dialog.widget;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LayoutAnimationController;
import android.view.animation.TranslateAnimation;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.flyco.dialog.entity.DialogMenuItem;
import com.flyco.dialog.listener.OnOperItemClickL;
import com.flyco.dialog.utils.CornerUtils;
import com.flyco.dialog.widget.base.BaseDialog;
import java.util.ArrayList;

public class NormalListDialog
extends BaseDialog<NormalListDialog> {
    private ListView mLv;
    private TextView mTvTitle;
    private float mCornerRadius = 5.0f;
    private int mTitleBgColor = Color.parseColor((String)"#303030");
    private String mTitle = "\u63d0\u793a";
    private int mTitleTextColor = Color.parseColor((String)"#ffffff");
    private float mTitleTextSize = 16.5f;
    private int mLvBgColor = Color.parseColor((String)"#ffffff");
    private int mDividerColor = -3355444;
    private float mDividerHeight = 0.8f;
    private int mItemPressColor = Color.parseColor((String)"#ffcccccc");
    private int mItemTextColor = Color.parseColor((String)"#303030");
    private float mItemTextSize = 15.0f;
    private int mItemExtraLeft;
    private int mItemExtraTop;
    private int mItemExtraRight;
    private int mItemExtraBottom;
    private boolean mIsTitleShow = true;
    private BaseAdapter mAdapter;
    private ArrayList<DialogMenuItem> mContents = new ArrayList();
    private OnOperItemClickL mOnOperItemClickL;
    private LayoutAnimationController mLac;

    public void setOnOperItemClickL(OnOperItemClickL onOperItemClickL) {
        this.mOnOperItemClickL = onOperItemClickL;
    }

    public NormalListDialog(Context context, ArrayList<DialogMenuItem> baseItems) {
        super(context);
        this.mContents.addAll(baseItems);
        this.init();
    }

    public NormalListDialog(Context context, String[] items) {
        super(context);
        this.mContents = new ArrayList();
        for (String item : items) {
            DialogMenuItem customBaseItem = new DialogMenuItem(item, 0);
            this.mContents.add(customBaseItem);
        }
        this.init();
    }

    public NormalListDialog(Context context, BaseAdapter adapter) {
        super(context);
        this.mAdapter = adapter;
        this.init();
    }

    private void init() {
        this.widthScale(0.8f);
        TranslateAnimation animation = new TranslateAnimation(1, 2.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f);
        animation.setInterpolator((Interpolator)new DecelerateInterpolator());
        animation.setDuration(550L);
        this.mLac = new LayoutAnimationController((Animation)animation, 0.12f);
        this.mLac.setInterpolator((Interpolator)new DecelerateInterpolator());
    }

    @Override
    public View onCreateView() {
        LinearLayout ll_container = new LinearLayout(this.mContext);
        ll_container.setOrientation(1);
        this.mTvTitle = new TextView(this.mContext);
        this.mTvTitle.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mTvTitle.setSingleLine(true);
        this.mTvTitle.setPadding(this.dp2px(18.0f), this.dp2px(10.0f), 0, this.dp2px(10.0f));
        ll_container.addView((View)this.mTvTitle);
        this.mLv = new ListView(this.mContext);
        this.mLv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mLv.setCacheColorHint(0);
        this.mLv.setFadingEdgeLength(0);
        this.mLv.setVerticalScrollBarEnabled(false);
        this.mLv.setSelector((Drawable)new ColorDrawable(0));
        ll_container.addView((View)this.mLv);
        return ll_container;
    }

    @Override
    public void setUiBeforShow() {
        float radius = this.dp2px(this.mCornerRadius);
        this.mTvTitle.setBackgroundDrawable(CornerUtils.cornerDrawable(this.mTitleBgColor, new float[]{radius, radius, radius, radius, 0.0f, 0.0f, 0.0f, 0.0f}));
        this.mTvTitle.setText((CharSequence)this.mTitle);
        this.mTvTitle.setTextSize(2, this.mTitleTextSize);
        this.mTvTitle.setTextColor(this.mTitleTextColor);
        this.mTvTitle.setVisibility(this.mIsTitleShow ? 0 : 8);
        this.mLv.setDivider((Drawable)new ColorDrawable(this.mDividerColor));
        this.mLv.setDividerHeight(this.dp2px(this.mDividerHeight));
        if (this.mIsTitleShow) {
            this.mLv.setBackgroundDrawable(CornerUtils.cornerDrawable(this.mLvBgColor, new float[]{0.0f, 0.0f, 0.0f, 0.0f, radius, radius, radius, radius}));
        } else {
            this.mLv.setBackgroundDrawable(CornerUtils.cornerDrawable(this.mLvBgColor, radius));
        }
        if (this.mAdapter == null) {
            this.mAdapter = new ListDialogAdapter();
        }
        this.mLv.setAdapter((ListAdapter)this.mAdapter);
        this.mLv.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                if (NormalListDialog.this.mOnOperItemClickL != null) {
                    NormalListDialog.this.mOnOperItemClickL.onOperItemClick(parent, view, position, id);
                }
            }
        });
        this.mLv.setLayoutAnimation(this.mLac);
    }

    public NormalListDialog titleBgColor(int titleBgColor) {
        this.mTitleBgColor = titleBgColor;
        return this;
    }

    public NormalListDialog title(String title) {
        this.mTitle = title;
        return this;
    }

    public NormalListDialog titleTextSize_SP(float titleTextSize_SP) {
        this.mTitleTextSize = titleTextSize_SP;
        return this;
    }

    public NormalListDialog titleTextColor(int titleTextColor) {
        this.mTitleTextColor = titleTextColor;
        return this;
    }

    public NormalListDialog isTitleShow(boolean isTitleShow) {
        this.mIsTitleShow = isTitleShow;
        return this;
    }

    public NormalListDialog lvBgColor(int lvBgColor) {
        this.mLvBgColor = lvBgColor;
        return this;
    }

    public NormalListDialog cornerRadius(float cornerRadius_DP) {
        this.mCornerRadius = cornerRadius_DP;
        return this;
    }

    public NormalListDialog dividerColor(int dividerColor) {
        this.mDividerColor = dividerColor;
        return this;
    }

    public NormalListDialog dividerHeight(float dividerHeight_DP) {
        this.mDividerHeight = dividerHeight_DP;
        return this;
    }

    public NormalListDialog itemPressColor(int itemPressColor) {
        this.mItemPressColor = itemPressColor;
        return this;
    }

    public NormalListDialog itemTextColor(int itemTextColor) {
        this.mItemTextColor = itemTextColor;
        return this;
    }

    public NormalListDialog itemTextSize(float itemTextSize_SP) {
        this.mItemTextSize = itemTextSize_SP;
        return this;
    }

    public NormalListDialog setItemExtraPadding(int itemLeft, int itemTop, int itemRight, int itemBottom) {
        this.mItemExtraLeft = this.dp2px(itemLeft);
        this.mItemExtraTop = this.dp2px(itemTop);
        this.mItemExtraRight = this.dp2px(itemRight);
        this.mItemExtraBottom = this.dp2px(itemBottom);
        return this;
    }

    public NormalListDialog layoutAnimation(LayoutAnimationController lac) {
        this.mLac = lac;
        return this;
    }

    class ListDialogAdapter
    extends BaseAdapter {
        ListDialogAdapter() {
        }

        public int getCount() {
            return NormalListDialog.this.mContents.size();
        }

        public Object getItem(int position) {
            return null;
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            DialogMenuItem item = (DialogMenuItem)NormalListDialog.this.mContents.get(position);
            LinearLayout llItem = new LinearLayout(NormalListDialog.this.mContext);
            llItem.setOrientation(0);
            llItem.setGravity(16);
            ImageView ivItem = new ImageView(NormalListDialog.this.mContext);
            ivItem.setPadding(0, 0, NormalListDialog.this.dp2px(15.0f), 0);
            llItem.addView((View)ivItem);
            TextView tvItem = new TextView(NormalListDialog.this.mContext);
            tvItem.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            tvItem.setSingleLine(true);
            tvItem.setTextColor(NormalListDialog.this.mItemTextColor);
            tvItem.setTextSize(2, NormalListDialog.this.mItemTextSize);
            llItem.addView((View)tvItem);
            float radius = NormalListDialog.this.dp2px(NormalListDialog.this.mCornerRadius);
            if (NormalListDialog.this.mIsTitleShow) {
                llItem.setBackgroundDrawable((Drawable)CornerUtils.listItemSelector(radius, 0, NormalListDialog.this.mItemPressColor, position == NormalListDialog.this.mContents.size() - 1));
            } else {
                llItem.setBackgroundDrawable((Drawable)CornerUtils.listItemSelector(radius, 0, NormalListDialog.this.mItemPressColor, NormalListDialog.this.mContents.size(), position));
            }
            int left = item.mResId == 0 ? NormalListDialog.this.dp2px(18.0f) : NormalListDialog.this.dp2px(16.0f);
            int top = NormalListDialog.this.dp2px(10.0f);
            int right = 0;
            int bottom = NormalListDialog.this.dp2px(10.0f);
            llItem.setPadding(left + NormalListDialog.this.mItemExtraLeft, top + NormalListDialog.this.mItemExtraTop, right + NormalListDialog.this.mItemExtraRight, bottom + NormalListDialog.this.mItemExtraBottom);
            ivItem.setImageResource(item.mResId);
            tvItem.setText((CharSequence)item.mOperName);
            ivItem.setVisibility(item.mResId == 0 ? 8 : 0);
            return llItem;
        }
    }
}

