/*
 * Decompiled with CFR 0.152.
 */
package com.flyco.dialog.widget;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LayoutAnimationController;
import android.view.animation.TranslateAnimation;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.flyco.dialog.entity.DialogMenuItem;
import com.flyco.dialog.listener.OnOperItemClickL;
import com.flyco.dialog.utils.CornerUtils;
import com.flyco.dialog.widget.base.BottomBaseDialog;
import java.util.ArrayList;

public class ActionSheetDialog
extends BottomBaseDialog<ActionSheetDialog> {
    private ListView mLv;
    private TextView mTvTitle;
    private View mVLineTitle;
    private TextView mTvCancel;
    private float mCornerRadius = 5.0f;
    private int mTitleBgColor = Color.parseColor((String)"#ddffffff");
    private String mTitle = "\u63d0\u793a";
    private float mTitleHeight = 48.0f;
    private int mTitleTextColor = Color.parseColor((String)"#8F8F8F");
    private float mTitleTextSize = 17.5f;
    private int mLvBgColor = Color.parseColor((String)"#ddffffff");
    private int mDividerColor = Color.parseColor((String)"#D7D7D9");
    private float mDividerHeight = 0.8f;
    private int mItemPressColor = Color.parseColor((String)"#ffcccccc");
    private int mItemTextColor = Color.parseColor((String)"#44A2FF");
    private float mItemTextSize = 17.5f;
    private float mItemHeight = 48.0f;
    private boolean mIsTitleShow = true;
    private String mCancelText = "\u53d6\u6d88";
    private int mCancelTextColor = Color.parseColor((String)"#44A2FF");
    private float mCancelTextSize = 17.5f;
    private BaseAdapter mAdapter;
    private ArrayList<DialogMenuItem> mContents = new ArrayList();
    private OnOperItemClickL mOnOperItemClickL;
    private LayoutAnimationController mLac;

    public void setOnOperItemClickL(OnOperItemClickL onOperItemClickL) {
        this.mOnOperItemClickL = onOperItemClickL;
    }

    public ActionSheetDialog(Context context, ArrayList<DialogMenuItem> baseItems, View animateView) {
        super(context, animateView);
        this.mContents.addAll(baseItems);
        this.init();
    }

    public ActionSheetDialog(Context context, String[] items, View animateView) {
        super(context, animateView);
        this.mContents = new ArrayList();
        for (String item : items) {
            DialogMenuItem customBaseItem = new DialogMenuItem(item, 0);
            this.mContents.add(customBaseItem);
        }
        this.init();
    }

    public ActionSheetDialog(Context context, BaseAdapter adapter, View animateView) {
        super(context, animateView);
        this.mAdapter = adapter;
        this.init();
    }

    private void init() {
        this.widthScale(0.95f);
        TranslateAnimation animation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 6.0f, 1, 0.0f);
        animation.setInterpolator((Interpolator)new DecelerateInterpolator());
        animation.setDuration(350L);
        animation.setStartOffset(150L);
        this.mLac = new LayoutAnimationController((Animation)animation, 0.12f);
        this.mLac.setInterpolator((Interpolator)new DecelerateInterpolator());
    }

    @Override
    public View onCreateView() {
        LinearLayout ll_container = new LinearLayout(this.mContext);
        ll_container.setOrientation(1);
        ll_container.setBackgroundColor(0);
        this.mTvTitle = new TextView(this.mContext);
        this.mTvTitle.setGravity(17);
        this.mTvTitle.setPadding(this.dp2px(10.0f), this.dp2px(5.0f), this.dp2px(10.0f), this.dp2px(5.0f));
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.topMargin = this.dp2px(20.0f);
        ll_container.addView((View)this.mTvTitle, (ViewGroup.LayoutParams)params);
        this.mVLineTitle = new View(this.mContext);
        ll_container.addView(this.mVLineTitle);
        this.mLv = new ListView(this.mContext);
        this.mLv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
        this.mLv.setCacheColorHint(0);
        this.mLv.setFadingEdgeLength(0);
        this.mLv.setVerticalScrollBarEnabled(false);
        this.mLv.setSelector((Drawable)new ColorDrawable(0));
        ll_container.addView((View)this.mLv);
        this.mTvCancel = new TextView(this.mContext);
        this.mTvCancel.setGravity(17);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
        lp.topMargin = this.dp2px(7.0f);
        lp.bottomMargin = this.dp2px(7.0f);
        this.mTvCancel.setLayoutParams((ViewGroup.LayoutParams)lp);
        ll_container.addView((View)this.mTvCancel);
        return ll_container;
    }

    @Override
    public void setUiBeforShow() {
        float radius = this.dp2px(this.mCornerRadius);
        this.mTvTitle.setHeight(this.dp2px(this.mTitleHeight));
        this.mTvTitle.setBackgroundDrawable(CornerUtils.cornerDrawable(this.mTitleBgColor, new float[]{radius, radius, radius, radius, 0.0f, 0.0f, 0.0f, 0.0f}));
        this.mTvTitle.setText((CharSequence)this.mTitle);
        this.mTvTitle.setTextSize(2, this.mTitleTextSize);
        this.mTvTitle.setTextColor(this.mTitleTextColor);
        this.mTvTitle.setVisibility(this.mIsTitleShow ? 0 : 8);
        this.mVLineTitle.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, this.dp2px(this.mDividerHeight)));
        this.mVLineTitle.setBackgroundColor(this.mDividerColor);
        this.mVLineTitle.setVisibility(this.mIsTitleShow ? 0 : 8);
        this.mTvCancel.setHeight(this.dp2px(this.mItemHeight));
        this.mTvCancel.setText((CharSequence)this.mCancelText);
        this.mTvCancel.setTextSize(2, this.mCancelTextSize);
        this.mTvCancel.setTextColor(this.mCancelTextColor);
        this.mTvCancel.setBackgroundDrawable((Drawable)CornerUtils.listItemSelector(radius, this.mLvBgColor, this.mItemPressColor, 1, 0));
        this.mTvCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ActionSheetDialog.this.dismiss();
            }
        });
        this.mLv.setDivider((Drawable)new ColorDrawable(this.mDividerColor));
        this.mLv.setDividerHeight(this.dp2px(this.mDividerHeight));
        if (this.mIsTitleShow) {
            this.mLv.setBackgroundDrawable(CornerUtils.cornerDrawable(this.mLvBgColor, new float[]{0.0f, 0.0f, 0.0f, 0.0f, radius, radius, radius, radius}));
        } else {
            this.mLv.setBackgroundDrawable(CornerUtils.cornerDrawable(this.mLvBgColor, radius));
        }
        if (this.mAdapter == null) {
            this.mAdapter = new ListDialogAdapter();
        }
        this.mLv.setAdapter((ListAdapter)this.mAdapter);
        this.mLv.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                if (ActionSheetDialog.this.mOnOperItemClickL != null) {
                    ActionSheetDialog.this.mOnOperItemClickL.onOperItemClick(parent, view, position, id);
                }
            }
        });
        this.mLv.setLayoutAnimation(this.mLac);
    }

    public ActionSheetDialog titleBgColor(int titleBgColor) {
        this.mTitleBgColor = titleBgColor;
        return this;
    }

    public ActionSheetDialog title(String title) {
        this.mTitle = title;
        return this;
    }

    public ActionSheetDialog titleHeight(float titleHeight) {
        this.mTitleHeight = titleHeight;
        return this;
    }

    public ActionSheetDialog titleTextSize_SP(float titleTextSize_SP) {
        this.mTitleTextSize = titleTextSize_SP;
        return this;
    }

    public ActionSheetDialog titleTextColor(int titleTextColor) {
        this.mTitleTextColor = titleTextColor;
        return this;
    }

    public ActionSheetDialog isTitleShow(boolean isTitleShow) {
        this.mIsTitleShow = isTitleShow;
        return this;
    }

    public ActionSheetDialog lvBgColor(int lvBgColor) {
        this.mLvBgColor = lvBgColor;
        return this;
    }

    public ActionSheetDialog cornerRadius(float cornerRadius_DP) {
        this.mCornerRadius = cornerRadius_DP;
        return this;
    }

    public ActionSheetDialog dividerColor(int dividerColor) {
        this.mDividerColor = dividerColor;
        return this;
    }

    public ActionSheetDialog dividerHeight(float dividerHeight_DP) {
        this.mDividerHeight = dividerHeight_DP;
        return this;
    }

    public ActionSheetDialog itemPressColor(int itemPressColor) {
        this.mItemPressColor = itemPressColor;
        return this;
    }

    public ActionSheetDialog itemTextColor(int itemTextColor) {
        this.mItemTextColor = itemTextColor;
        return this;
    }

    public ActionSheetDialog itemTextSize(float itemTextSize_SP) {
        this.mItemTextSize = itemTextSize_SP;
        return this;
    }

    public ActionSheetDialog itemHeight(float itemHeight_DP) {
        this.mItemHeight = itemHeight_DP;
        return this;
    }

    public ActionSheetDialog layoutAnimation(LayoutAnimationController lac) {
        this.mLac = lac;
        return this;
    }

    public ActionSheetDialog cancelText(String cancelText) {
        this.mCancelText = cancelText;
        return this;
    }

    public ActionSheetDialog cancelText(int cancelTextColor) {
        this.mCancelTextColor = cancelTextColor;
        return this;
    }

    public ActionSheetDialog cancelTextSize(float cancelTextSize) {
        this.mCancelTextSize = cancelTextSize;
        return this;
    }

    class ListDialogAdapter
    extends BaseAdapter {
        ListDialogAdapter() {
        }

        public int getCount() {
            return ActionSheetDialog.this.mContents.size();
        }

        public Object getItem(int position) {
            return null;
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            DialogMenuItem item = (DialogMenuItem)ActionSheetDialog.this.mContents.get(position);
            LinearLayout llItem = new LinearLayout(ActionSheetDialog.this.mContext);
            llItem.setOrientation(0);
            llItem.setGravity(16);
            ImageView ivItem = new ImageView(ActionSheetDialog.this.mContext);
            ivItem.setPadding(0, 0, ActionSheetDialog.this.dp2px(15.0f), 0);
            llItem.addView((View)ivItem);
            TextView tvItem = new TextView(ActionSheetDialog.this.mContext);
            tvItem.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            tvItem.setSingleLine(true);
            tvItem.setGravity(17);
            tvItem.setTextColor(ActionSheetDialog.this.mItemTextColor);
            tvItem.setTextSize(2, ActionSheetDialog.this.mItemTextSize);
            tvItem.setHeight(ActionSheetDialog.this.dp2px(ActionSheetDialog.this.mItemHeight));
            llItem.addView((View)tvItem);
            float radius = ActionSheetDialog.this.dp2px(ActionSheetDialog.this.mCornerRadius);
            if (ActionSheetDialog.this.mIsTitleShow) {
                llItem.setBackgroundDrawable((Drawable)CornerUtils.listItemSelector(radius, 0, ActionSheetDialog.this.mItemPressColor, position == ActionSheetDialog.this.mContents.size() - 1));
            } else {
                llItem.setBackgroundDrawable((Drawable)CornerUtils.listItemSelector(radius, 0, ActionSheetDialog.this.mItemPressColor, ActionSheetDialog.this.mContents.size(), position));
            }
            ivItem.setImageResource(item.mResId);
            tvItem.setText((CharSequence)item.mOperName);
            ivItem.setVisibility(item.mResId == 0 ? 8 : 0);
            return llItem;
        }
    }
}

