/*
 * Decompiled with CFR 0.152.
 */
package com.flyco.dialog.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;

public class TriangleView
extends View {
    private Paint mPaint = new Paint(1);
    private Path mPath = new Path();
    private int mColor;
    private int mGravity;

    public TriangleView(Context context) {
        super(context);
    }

    public TriangleView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setColor(int color) {
        this.mColor = color;
        this.invalidate();
    }

    public void setGravity(int gravity) {
        this.mGravity = gravity;
        this.invalidate();
    }

    public int getColor() {
        return this.mColor;
    }

    public int getGravity() {
        return this.mGravity;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        this.mPaint.setColor(this.mColor);
        this.mPath.reset();
        if (this.mGravity == 48) {
            this.mPath.moveTo((float)(width / 2), 0.0f);
            this.mPath.lineTo(0.0f, (float)height);
            this.mPath.lineTo((float)width, (float)height);
            this.mPath.close();
        } else if (this.mGravity == 80) {
            this.mPath.moveTo(0.0f, 0.0f);
            this.mPath.lineTo((float)width, 0.0f);
            this.mPath.lineTo((float)(width / 2), (float)height);
            this.mPath.close();
        }
        canvas.drawPath(this.mPath, this.mPaint);
    }
}

