/*
 * Decompiled with CFR 0.152.
 */
package com.flyco.dialog.utils;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;

public class StatusBarUtils {
    public static int getHeight(Context context) {
        int statusBarHeight = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = context.getResources().getDimensionPixelSize(resourceId);
        }
        Log.d((String)StatusBarUtils.class.getSimpleName(), (String)("statusBarHeight--->" + statusBarHeight));
        if (StatusBarUtils.isFlymeOs4x()) {
            return 2 * statusBarHeight;
        }
        return statusBarHeight;
    }

    public static boolean isFlymeOs4x() {
        String sysVersion = Build.VERSION.RELEASE;
        if ("4.4.4".equals(sysVersion)) {
            String sysIncrement = Build.VERSION.INCREMENTAL;
            String displayId = Build.DISPLAY;
            if (!TextUtils.isEmpty((CharSequence)sysIncrement)) {
                return sysIncrement.contains("Flyme_OS_4");
            }
            return displayId.contains("Flyme OS 4");
        }
        return false;
    }
}

