/*
 * Decompiled with CFR 0.152.
 */
package com.flyco.animation;

import android.view.View;
import android.view.animation.Interpolator;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.view.ViewHelper;

public abstract class BaseAnimatorSet {
    protected long duration = 500L;
    protected AnimatorSet animatorSet = new AnimatorSet();
    private Interpolator interpolator;
    private long delay;
    private AnimatorListener listener;

    public abstract void setAnimation(View var1);

    protected void start(View view) {
        BaseAnimatorSet.reset(view);
        this.setAnimation(view);
        this.animatorSet.setDuration(this.duration);
        if (this.interpolator != null) {
            this.animatorSet.setInterpolator(this.interpolator);
        }
        if (this.delay > 0L) {
            this.animatorSet.setStartDelay(this.delay);
        }
        if (this.listener != null) {
            this.animatorSet.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animator) {
                    BaseAnimatorSet.this.listener.onAnimationStart(animator);
                }

                public void onAnimationRepeat(Animator animator) {
                    BaseAnimatorSet.this.listener.onAnimationRepeat(animator);
                }

                public void onAnimationEnd(Animator animator) {
                    BaseAnimatorSet.this.listener.onAnimationEnd(animator);
                }

                public void onAnimationCancel(Animator animator) {
                    BaseAnimatorSet.this.listener.onAnimationCancel(animator);
                }
            });
        }
        this.animatorSet.start();
    }

    public static void reset(View view) {
        ViewHelper.setAlpha((View)view, (float)1.0f);
        ViewHelper.setScaleX((View)view, (float)1.0f);
        ViewHelper.setScaleY((View)view, (float)1.0f);
        ViewHelper.setTranslationX((View)view, (float)0.0f);
        ViewHelper.setTranslationY((View)view, (float)0.0f);
        ViewHelper.setRotation((View)view, (float)0.0f);
        ViewHelper.setRotationY((View)view, (float)0.0f);
        ViewHelper.setRotationX((View)view, (float)0.0f);
    }

    public BaseAnimatorSet duration(long duration) {
        this.duration = duration;
        return this;
    }

    public BaseAnimatorSet delay(long delay) {
        this.delay = delay;
        return this;
    }

    public BaseAnimatorSet interpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
        return this;
    }

    public BaseAnimatorSet listener(AnimatorListener listener) {
        this.listener = listener;
        return this;
    }

    public void playOn(View view) {
        this.start(view);
    }

    public static interface AnimatorListener {
        public void onAnimationStart(Animator var1);

        public void onAnimationRepeat(Animator var1);

        public void onAnimationEnd(Animator var1);

        public void onAnimationCancel(Animator var1);
    }
}

