/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.db;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.TypeConverters;
import android.arch.persistence.room.migration.Migration;
import android.content.Context;
import com.flybits.android.push.db.converters.CustomFieldsConverter;
import com.flybits.android.push.db.converters.PushEnumConverter;
import com.flybits.android.push.db.dao.PushDao;
import com.flybits.android.push.models.Push;

@Database(entities={Push.class}, version=3)
@TypeConverters(value={PushEnumConverter.class, CustomFieldsConverter.class})
public abstract class PushDatabase
extends RoomDatabase {
    private static PushDatabase INSTANCE;
    static final Migration MIGRATION_1_3;
    static final Migration MIGRATION_2_3;

    public abstract PushDao pushDao();

    public static PushDatabase getDatabase(Context context) {
        if (INSTANCE == null) {
            INSTANCE = (PushDatabase)Room.databaseBuilder((Context)context, PushDatabase.class, (String)"flybits-push-db").addMigrations(new Migration[]{MIGRATION_1_3}).addMigrations(new Migration[]{MIGRATION_2_3}).fallbackToDestructiveMigration().build();
        }
        return INSTANCE;
    }

    static {
        MIGRATION_1_3 = new Migration(1, 3){

            public void migrate(SupportSQLiteDatabase database) {
                database.execSQL("ALTER TABLE push ADD COLUMN metadataID TEXT");
            }
        };
        MIGRATION_2_3 = new Migration(2, 3){

            public void migrate(SupportSQLiteDatabase database) {
                database.execSQL("ALTER TABLE push ADD COLUMN metadataID TEXT");
            }
        };
    }
}

