/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.api;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.flybits.android.push.deserializations.DeserializePushPreferences;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.Result;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PushPreferenceManager {
    static final String API = "/push/preferences";

    public static BasicResult subscribe(final @NonNull Context context, final @NonNull String topic, @NonNull BasicResultCallback callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult query = new BasicResult(context, callback, executorService, handler);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Result resultGetSubscriptions = FlyAway.get((Context)context, (String)PushPreferenceManager.API, (IDeserializer)new DeserializePushPreferences(), (String)"PushPreferenceManager.subscribe1", String[].class);
                    if (resultGetSubscriptions.getStatus() == RequestStatus.COMPLETED) {
                        ArrayList<Object> listOfUnsubscribedTopic = new ArrayList<Object>(Arrays.asList((Object[])resultGetSubscriptions.getResult()));
                        if (listOfUnsubscribedTopic.contains(topic)) {
                            listOfUnsubscribedTopic.remove(topic);
                            String[] listOfTopics = listOfUnsubscribedTopic.toArray(new String[listOfUnsubscribedTopic.size()]);
                            String json = new DeserializePushPreferences().toJson(listOfTopics);
                            Result resultSubscribe = FlyAway.post((Context)context, (String)PushPreferenceManager.API, (String)json, null, (String)"PushPreferenceManager.subscribe2", null);
                            query.setResult(resultSubscribe);
                        } else {
                            query.setResult(resultGetSubscriptions);
                        }
                    } else {
                        query.setResult(resultGetSubscriptions);
                    }
                }
                catch (FlybitsException e) {
                    query.setFailed(e);
                }
            }
        });
        return query;
    }

    public static BasicResult unsubscribe(final @NonNull Context context, final @NonNull String topic, @NonNull BasicResultCallback callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult query = new BasicResult(context, callback, executorService, handler);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Result resultGetSubscriptions = FlyAway.get((Context)context, (String)PushPreferenceManager.API, (IDeserializer)new DeserializePushPreferences(), (String)"PushPreferenceManager.unsubscribe1", String[].class);
                    if (resultGetSubscriptions.getStatus() == RequestStatus.COMPLETED) {
                        ArrayList<Object> listOfUnsubscribedTopic = new ArrayList<Object>(Arrays.asList((Object[])resultGetSubscriptions.getResult()));
                        if (!listOfUnsubscribedTopic.contains(topic)) {
                            listOfUnsubscribedTopic.add(topic);
                            String[] listOfTopics = listOfUnsubscribedTopic.toArray(new String[listOfUnsubscribedTopic.size()]);
                            String json = new DeserializePushPreferences().toJson(listOfTopics);
                            Result resultUnsubscribe = FlyAway.post((Context)context, (String)PushPreferenceManager.API, (String)json, null, (String)"PushPreferenceManager.unsubscribe2", null);
                            query.setResult(resultUnsubscribe);
                        } else {
                            query.setResult(resultGetSubscriptions);
                        }
                    } else {
                        query.setResult(resultGetSubscriptions);
                    }
                }
                catch (FlybitsException e) {
                    query.setFailed(e);
                }
            }
        });
        return query;
    }

    public static BasicResult clear(final @NonNull Context context, @NonNull BasicResultCallback callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult query = new BasicResult(context, callback, executorService, handler);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Result result = FlyAway.delete((Context)context, (String)PushPreferenceManager.API, (String)"PushPreferenceManager.clear", null);
                    query.setResult(result);
                }
                catch (FlybitsException e) {
                    query.setFailed(e);
                }
            }
        });
        return query;
    }

    public static ObjectResult<String[]> get(final @NonNull Context context, @NonNull ObjectResultCallback<String[]> callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult query = new ObjectResult(context, callback, executorService, handler);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Result result = FlyAway.get((Context)context, (String)PushPreferenceManager.API, (IDeserializer)new DeserializePushPreferences(), (String)"PushPreferenceManager.get", String[].class);
                    query.setResult(result);
                }
                catch (FlybitsException e) {
                    query.setFailed(e);
                }
            }
        });
        return query;
    }

    public static BasicResult override(final @NonNull Context context, final @NonNull ArrayList<String> keywords, BasicResultCallback callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult query = new BasicResult(context, callback, executorService, handler);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String[] listOfTopics = keywords.toArray(new String[keywords.size()]);
                    String json = new DeserializePushPreferences().toJson(listOfTopics);
                    Result result = FlyAway.post((Context)context, (String)PushPreferenceManager.API, (String)json, null, (String)"PushPreferenceManager.post", null);
                    query.setResult(result);
                }
                catch (FlybitsException e) {
                    query.setFailed(e);
                }
            }
        });
        return query;
    }
}

