package com.flybits.android.push.db;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.TypeConverters;
import android.arch.persistence.room.migration.Migration;
import android.content.Context;

import com.flybits.android.push.db.converters.CustomFieldsConverter;
import com.flybits.android.push.db.converters.PushEnumConverter;
import com.flybits.android.push.db.dao.PushDao;
import com.flybits.android.push.models.Push;

@Database(entities = {Push.class}, version = 3)
@TypeConverters({PushEnumConverter.class, CustomFieldsConverter.class})
public abstract class PushDatabase extends RoomDatabase {

    private static PushDatabase INSTANCE;
    public abstract PushDao pushDao();

    public static PushDatabase getDatabase(Context context) {
        if (INSTANCE == null) {
            INSTANCE = Room.databaseBuilder(context, PushDatabase.class, "flybits-push-db")
                    .addMigrations(MIGRATION_1_3)
                    .addMigrations(MIGRATION_2_3)
                    .fallbackToDestructiveMigration()
                    .build();
        }
        return INSTANCE;
    }

    static final Migration MIGRATION_1_3 = new Migration(1, 3) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE push ADD COLUMN metadataID TEXT");
        }
    };

    static final Migration MIGRATION_2_3 = new Migration(2, 3) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {

            database.execSQL("ALTER TABLE push ADD COLUMN metadataID TEXT");

        }
    };
}