/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.models;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.flybits.android.push.deserializations.DeserializePushTemplate;
import com.flybits.android.push.models.PushTemplateOptions;
import com.flybits.android.push.models.results.PushTemplateResult;
import com.flybits.android.push.utils.PushTemplateQueryParameters;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.deserializations.DeserializePagedResponse;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PushTemplate {
    static final String API = "/push/pushrequests";
    static final String USER_SCOPE = "/userscoped";
    private String action;
    private Context context;
    private String id;
    private PushTemplateOptions options;
    private String message;
    private String name;
    private String title;
    private HashMap<String, String> customFields;
    private HashMap<String, String> listOfUsers;
    private HashMap<String, Integer> listOfRules;

    private PushTemplate(Builder builder) {
        this.context = builder.context;
        this.title = builder.title;
        this.message = builder.message;
        this.name = builder.name;
        if (builder.id != null) {
            this.id = builder.id;
        }
        if (builder.action != null) {
            this.action = builder.action;
        }
        if (builder.customFields != null) {
            this.customFields = builder.customFields;
        }
        if (builder.options != null) {
            this.options = builder.options;
        }
        if (builder.listOfRules != null && builder.listOfRules.size() > 0) {
            this.listOfRules = builder.listOfRules;
        }
        if (builder.listOfUsers != null && builder.listOfUsers.size() > 0) {
            this.listOfUsers = builder.listOfUsers;
        }
    }

    public ObjectResult<PushTemplate> create(@NonNull Context mContext, @NonNull ObjectResultCallback<PushTemplate> callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult query = new ObjectResult(mContext, callback, executorService, handler);
        query.setService(executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DeserializePushTemplate deserializer = new DeserializePushTemplate(PushTemplate.this.context);
                    String jsonBody = deserializer.toJson(PushTemplate.this);
                    Result result = FlyAway.post((Context)PushTemplate.this.context, (String)"/push/pushrequests/userscoped", (String)jsonBody, (IDeserializer)deserializer, (String)"PushTemplate.create", PushTemplate.class);
                    query.setResult(result);
                }
                catch (FlybitsException e) {
                    query.setFailed(e);
                }
            }
        });
        return query;
    }

    public BasicResult delete(@NonNull Context mContext, @NonNull BasicResultCallback callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult resultObject = new BasicResult(mContext, callback, executorService, handler);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Result result = FlyAway.delete((Context)PushTemplate.this.context, (String)PushTemplate.API, (String)"PushTemplate.delete", (String)(PushTemplate.this.id + PushTemplate.USER_SCOPE));
                    resultObject.setResult(result);
                }
                catch (FlybitsException e) {
                    resultObject.setFailed(e);
                }
            }
        });
        return resultObject;
    }

    public static PushTemplateResult get(final @NonNull Context mContext, final @NonNull PushTemplateQueryParameters options, PagedResultCallback<PushTemplate> callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final PushTemplateResult query = new PushTemplateResult(mContext, callback, executorService, options, handler);
        query.setService(executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DeserializePushTemplate singleDersializer = new DeserializePushTemplate(mContext);
                    Result result = FlyAway.get((Context)mContext, (String)"/push/pushrequests/userscoped", (QueryParameters)options, (IDeserializer)new DeserializePagedResponse((IDeserializer)singleDersializer), (String)"PushTemplate.get");
                    query.setResult(result, options);
                }
                catch (FlybitsException e) {
                    query.setFailed(e);
                }
            }
        });
        return query;
    }

    public String getAction() {
        return this.action;
    }

    public HashMap<String, String> getCustomFields() {
        if (this.customFields == null) {
            return new HashMap<String, String>();
        }
        return this.customFields;
    }

    public String getId() {
        return this.id;
    }

    public HashMap<String, Integer> getListOfRules() {
        if (this.listOfRules == null) {
            return new HashMap<String, Integer>();
        }
        return this.listOfRules;
    }

    public HashMap<String, String> getListOfUsers() {
        if (this.listOfUsers == null) {
            return new HashMap<String, String>();
        }
        return this.listOfUsers;
    }

    public PushTemplateOptions getOptions() {
        return this.options;
    }

    public String getMessage() {
        return this.message;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public static enum ResultType {
        CHANGED_TO_TRUE(1),
        CHANGED_TO_FALSE(2),
        CHANGED_TO_TRUE_OR_FALSE(3),
        UNKNOWN(-99);

        private final int key;

        private ResultType(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public static ResultType fromKey(int key) {
            for (ResultType type : ResultType.values()) {
                if (type.getKey() != key) continue;
                return type;
            }
            return UNKNOWN;
        }
    }

    public static class Builder {
        private Context context;
        private String title;
        private String message;
        private String action;
        private String name;
        private String id;
        private PushTemplateOptions options;
        private HashMap<String, String> customFields;
        private HashMap<String, String> listOfUsers;
        private HashMap<String, Integer> listOfRules;

        public Builder(Context context, String name, String title, String message) {
            this.context = context;
            this.title = title;
            this.message = message;
            this.action = "custom";
            this.name = name;
            this.listOfRules = new HashMap();
            this.listOfUsers = new HashMap();
            this.customFields = new HashMap();
        }

        public Builder addCustomField(@NonNull String key, @NonNull String value) {
            this.customFields.put(key, value);
            return this;
        }

        public Builder addRule(@NonNull String ruleID, ResultType result) throws IllegalArgumentException {
            if (result == ResultType.UNKNOWN) {
                throw new IllegalArgumentException("The result cannot be ResultType.UNKNOWN");
            }
            this.listOfRules.put(ruleID, result.getKey());
            return this;
        }

        public Builder addUser(@NonNull String userID, @NonNull String deviceID) throws IllegalArgumentException {
            this.listOfUsers.put(userID, deviceID);
            return this;
        }

        public Builder setAction(String action) {
            this.action = action;
            return this;
        }

        public Builder setID(@NonNull String id) {
            this.id = id;
            return this;
        }

        public Builder setOptions(int max, int delay, int cooldown) {
            this.options = new PushTemplateOptions(max, delay, cooldown);
            return this;
        }

        public PushTemplate build() throws IllegalArgumentException {
            if (this.listOfRules == null || this.listOfRules.size() == 0) {
                throw new IllegalArgumentException("A valid Push Notification must have called the addRule(String, int) method called at least once.");
            }
            return new PushTemplate(this);
        }
    }
}

