/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.db;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.db.SupportSQLiteOpenHelper;
import android.arch.persistence.room.DatabaseConfiguration;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomOpenHelper;
import android.arch.persistence.room.util.TableInfo;
import android.content.Context;
import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.android.kernel.db.dao.ContentDao;
import com.flybits.android.kernel.db.dao.ContentDao_Impl;
import com.flybits.android.kernel.db.dao.GroupDao;
import com.flybits.android.kernel.db.dao.GroupDao_Impl;
import java.util.HashMap;
import java.util.HashSet;

public class KernelDatabase_Impl
extends KernelDatabase {
    private volatile ContentDao _contentDao;
    private volatile GroupDao _groupDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(7){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `content` (`id` TEXT NOT NULL, `templateId` TEXT, `nameObject` TEXT, `descriptionObject` TEXT, `createdAt` INTEGER NOT NULL, `modifiedAt` INTEGER NOT NULL, `evaluatedAt` INTEGER NOT NULL, `icon` TEXT, `dataAsJson` TEXT, `type` TEXT, `experienceId` TEXT, `pushRequestId` TEXT, `metadata` TEXT, `isFavourite` INTEGER NOT NULL, `labels` TEXT, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `groups` (`id` TEXT NOT NULL, `creatorId` TEXT, `nameObject` TEXT, `descriptionObject` TEXT, `createdAt` INTEGER NOT NULL, `modifiedAt` INTEGER NOT NULL, `defaultLanguage` TEXT, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, \"cc2375ea8cabe2723f6c0028b136a85f\")");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `content`");
                _db.execSQL("DROP TABLE IF EXISTS `groups`");
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (KernelDatabase_Impl.this.mCallbacks != null) {
                    int _size = KernelDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)KernelDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                KernelDatabase_Impl.this.mDatabase = _db;
                KernelDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (KernelDatabase_Impl.this.mCallbacks != null) {
                    int _size = KernelDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)KernelDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            protected void validateMigration(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsContent = new HashMap<String, TableInfo.Column>(15);
                _columnsContent.put("id", new TableInfo.Column("id", "TEXT", true, 1));
                _columnsContent.put("templateId", new TableInfo.Column("templateId", "TEXT", false, 0));
                _columnsContent.put("nameObject", new TableInfo.Column("nameObject", "TEXT", false, 0));
                _columnsContent.put("descriptionObject", new TableInfo.Column("descriptionObject", "TEXT", false, 0));
                _columnsContent.put("createdAt", new TableInfo.Column("createdAt", "INTEGER", true, 0));
                _columnsContent.put("modifiedAt", new TableInfo.Column("modifiedAt", "INTEGER", true, 0));
                _columnsContent.put("evaluatedAt", new TableInfo.Column("evaluatedAt", "INTEGER", true, 0));
                _columnsContent.put("icon", new TableInfo.Column("icon", "TEXT", false, 0));
                _columnsContent.put("dataAsJson", new TableInfo.Column("dataAsJson", "TEXT", false, 0));
                _columnsContent.put("type", new TableInfo.Column("type", "TEXT", false, 0));
                _columnsContent.put("experienceId", new TableInfo.Column("experienceId", "TEXT", false, 0));
                _columnsContent.put("pushRequestId", new TableInfo.Column("pushRequestId", "TEXT", false, 0));
                _columnsContent.put("metadata", new TableInfo.Column("metadata", "TEXT", false, 0));
                _columnsContent.put("isFavourite", new TableInfo.Column("isFavourite", "INTEGER", true, 0));
                _columnsContent.put("labels", new TableInfo.Column("labels", "TEXT", false, 0));
                HashSet _foreignKeysContent = new HashSet(0);
                HashSet _indicesContent = new HashSet(0);
                TableInfo _infoContent = new TableInfo("content", _columnsContent, _foreignKeysContent, _indicesContent);
                TableInfo _existingContent = TableInfo.read((SupportSQLiteDatabase)_db, (String)"content");
                if (!_infoContent.equals((Object)_existingContent)) {
                    throw new IllegalStateException("Migration didn't properly handle content(com.flybits.android.kernel.models.Content).\n Expected:\n" + _infoContent + "\n Found:\n" + _existingContent);
                }
                HashMap<String, TableInfo.Column> _columnsGroups = new HashMap<String, TableInfo.Column>(7);
                _columnsGroups.put("id", new TableInfo.Column("id", "TEXT", true, 1));
                _columnsGroups.put("creatorId", new TableInfo.Column("creatorId", "TEXT", false, 0));
                _columnsGroups.put("nameObject", new TableInfo.Column("nameObject", "TEXT", false, 0));
                _columnsGroups.put("descriptionObject", new TableInfo.Column("descriptionObject", "TEXT", false, 0));
                _columnsGroups.put("createdAt", new TableInfo.Column("createdAt", "INTEGER", true, 0));
                _columnsGroups.put("modifiedAt", new TableInfo.Column("modifiedAt", "INTEGER", true, 0));
                _columnsGroups.put("defaultLanguage", new TableInfo.Column("defaultLanguage", "TEXT", false, 0));
                HashSet _foreignKeysGroups = new HashSet(0);
                HashSet _indicesGroups = new HashSet(0);
                TableInfo _infoGroups = new TableInfo("groups", _columnsGroups, _foreignKeysGroups, _indicesGroups);
                TableInfo _existingGroups = TableInfo.read((SupportSQLiteDatabase)_db, (String)"groups");
                if (!_infoGroups.equals((Object)_existingGroups)) {
                    throw new IllegalStateException("Migration didn't properly handle groups(com.flybits.android.kernel.models.Group).\n Expected:\n" + _infoGroups + "\n Found:\n" + _existingGroups);
                }
            }
        }, "cc2375ea8cabe2723f6c0028b136a85f", "43c537419ae22959457f7a1e0b788dee");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        return new InvalidationTracker((RoomDatabase)this, new String[]{"content", "groups"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `content`");
            _db.execSQL("DELETE FROM `groups`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentDao contentDao() {
        if (this._contentDao != null) {
            return this._contentDao;
        }
        KernelDatabase_Impl kernelDatabase_Impl = this;
        synchronized (kernelDatabase_Impl) {
            if (this._contentDao == null) {
                this._contentDao = new ContentDao_Impl(this);
            }
            return this._contentDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GroupDao groupDao() {
        if (this._groupDao != null) {
            return this._groupDao;
        }
        KernelDatabase_Impl kernelDatabase_Impl = this;
        synchronized (kernelDatabase_Impl) {
            if (this._groupDao == null) {
                this._groupDao = new GroupDao_Impl(this);
            }
            return this._groupDao;
        }
    }
}

