package com.flybits.android.kernel.models.results;

import android.content.Context;
import android.os.Handler;
import com.flybits.android.kernel.models.Experience;
import com.flybits.android.kernel.utilities.ExperienceParameters;
import com.flybits.commons.library.api.results.PagedResult;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.models.internal.QueryParameters;
import org.jetbrains.annotations.NotNull;

import java.util.concurrent.ExecutorService;

public class ExperienceResult extends PagedResult<Experience> {

    public ExperienceResult(Context context, QueryParameters params, PagedResultCallback<Experience> callback, ExecutorService service, Handler handler){
        super(context, params, callback, handler, service);
    }

    @Override
    public <K extends QueryParameters> void getMoreRequest(@NotNull K k, @NotNull PagedResultCallback<Experience> pagedResultCallback) {
        Experience.get(getContext(), (ExperienceParameters) k, pagedResultCallback);
    }
}
