package com.flybits.android.kernel.reservedtemplates.survey.models;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;

/**
 * A POJO containing the survey results from a {@code SurveyResult} content instance. Eacy result
 * is the saved data for a single {@code Question}. Depending on the type, it will either contain
 * an array list of answers (for text input or multi choice questions), or a list of {@code ResultChoice}
 * objects which contain the number of votes for a single choice question.
 */

public class Result implements Parcelable {

    public ArrayList<String> answers = new ArrayList<>();
    public ArrayList<ResultChoice> choices;
    public Long questionNumber;

    public Result(){}

    protected Result(Parcel in) {
        in.readStringList(answers);
        in.readTypedList(choices, ResultChoice.CREATOR);
        questionNumber = in.readLong();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStringList(answers);
        dest.writeTypedList(choices);
        dest.writeLong(questionNumber);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<Result> CREATOR = new Creator<Result>() {
        @Override
        public Result createFromParcel(Parcel in) {
            return new Result(in);
        }

        @Override
        public Result[] newArray(int size) {
            return new Result[size];
        }
    };
}
