package com.flybits.android.kernel.deserializers;

import android.content.Context;

import com.flybits.android.kernel.models.Experience;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.deserializations.IDeserializer;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Iterator;

public class DeserializeExperience extends IDeserializer<Experience> {

    private Context context;

    public DeserializeExperience(Context context){
        this.context        = context;
    }

    @Override
    public String toJson(Experience experience) {
        JSONObject object = new JSONObject();

        try {
            object.put("creatorId", experience.getCreatorID());
        } catch (JSONException e) {}

        try {
            object.put("defaultLanguage", "en");
        } catch (JSONException e) {}

        JSONObject localizationObject   = new JSONObject();
        ArrayList<String> listofCodes   = new ArrayList<>();
        for (String code : experience.getNameObject().getListOfSupportedLanguages()){

            try {
                if (experience.getName(code) != null) {

                    listofCodes.add(code);
                    JSONObject objectLanguageCode   = new JSONObject();
                    objectLanguageCode.put("name", experience.getName(code));
                    localizationObject.put(code, objectLanguageCode);

                    if (experience.getDescription(code) != null) {
                        objectLanguageCode.put("description", experience.getDescription(code));
                        localizationObject.put(code, objectLanguageCode);
                    }
                }
            } catch (JSONException e) {}
        }

        for (String code : experience.getDescriptionObject().getListOfSupportedLanguages()){

            try {
                if (!listofCodes.contains(code) && experience.getDescription(code) != null) {
                    JSONObject objectLanguageCode   = new JSONObject();
                    objectLanguageCode.put("description", experience.getDescription(code));
                    localizationObject.put(code, objectLanguageCode);
                }
            } catch (JSONException e) {}
        }

        try {
            object.put("localizations", localizationObject);
        } catch (JSONException e) {}

        try {
            object.put("isActive", experience.isActive());
        } catch (JSONException e) {}

        return object.toString();
    }

    @Override
    public Experience fromJson(JSONObject jsonObject) {
        try {
            if (!jsonObject.isNull("id") && !jsonObject.isNull("creatorId") && !jsonObject.isNull("isActive")) {

                String id               = jsonObject.getString("id");
                String creatorId        = jsonObject.getString("creatorId");
                boolean isActive        = jsonObject.getBoolean("isActive");
                ArrayList<String> labels    = new ArrayList<>();

                long createdAt = -1, modifiedAt = -1;
                if (!jsonObject.isNull("createdAt")) {
                    createdAt   = jsonObject.getLong("createdAt");
                }
                if (!jsonObject.isNull("modifiedAt")) {
                    modifiedAt  = jsonObject.getLong("modifiedAt");
                }
                if (!jsonObject.isNull("labels")){
                    JSONArray jsonArray = jsonObject.getJSONArray("labels");
                    for (int i = 0; i < jsonArray.length(); i++){
                        labels.add(jsonArray.getString(i));
                    }
                }

                //TODO: en should be obtained from somewhere else
                Experience experience   = new Experience(id, creatorId, "en",
                        isActive, createdAt, modifiedAt, SharedElementsFactory.INSTANCE.get(context).getEnabledLanguagesAsString(), labels);

                if (!jsonObject.isNull("localizations")){

                    JSONObject localizationObject   = jsonObject.getJSONObject("localizations");
                    Iterator<String> languages      = localizationObject.keys();

                    while (languages.hasNext()){

                        String language             = languages.next();
                        JSONObject languageObj      = localizationObject.getJSONObject(language);
                        if (!languageObj.isNull("description")){
                            experience.setDescription(language, languageObj.getString("description"));
                        }

                        if (!languageObj.isNull("name")){
                            experience.setName(language, languageObj.getString("name"));
                        }
                    }
                }
                return experience;
            }
            return null;
        }catch (JSONException e){
            return null;
        }
    }

    @Override
    public Experience fromJson(JSONArray jsonArray) {
        return null;
    }
}
