package com.flybits.android.kernel;


import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;

import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.android.kernel.workers.FavouritesSyncWorker;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.models.User;

import java.util.concurrent.TimeUnit;

import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;

import static android.content.Context.MODE_PRIVATE;

public class KernelScope extends FlybitsScope{

    private static final String WORKER_NAME_CONTENT_FAVS  = "Get_Content_Favs";
    public static final String ROOT = "/kernel";

    public static KernelScope SCOPE = new KernelScope();

    private KernelScope(){
        super("Kernel");
    }

    @Override
    public void onConnected(Context context, User user) {
        PeriodicWorkRequest taskGetPluginsRepeat = new PeriodicWorkRequest.Builder(FavouritesSyncWorker.class, 1, TimeUnit.DAYS)
                .addTag(WORKER_NAME_CONTENT_FAVS)
                .build();
        WorkManager.getInstance().enqueueUniquePeriodicWork(WORKER_NAME_CONTENT_FAVS, ExistingPeriodicWorkPolicy.REPLACE, taskGetPluginsRepeat);
    }

    @Override
    public void onDisconnected(Context context, String s) {
        WorkManager.getInstance().cancelUniqueWork(WORKER_NAME_CONTENT_FAVS);
        new ClearDatabase(context).execute();
    }

    @Override
    public void onAccountDestroyed(Context context, String s) {
        new ClearDatabase(context).execute();
    }

    /**
     * Get the default shared preferences for the application.
     *
     * @param context The context of the application.
     * @return The default SharedPreferences object for the application.
     */
    public static SharedPreferences getKernelPreferences(Context context){
        return context.getSharedPreferences("FLYBITS_PREF_KERNEL", MODE_PRIVATE );
    }

    private class ClearDatabase extends AsyncTask<Void, Void, Void> {

        private Context context;

        public ClearDatabase(Context context){
            this.context    = context;
        }

        protected Void doInBackground(Void... urls) {
            KernelDatabase.getDatabase(context).contentDao().clear();
            KernelDatabase.getDatabase(context).groupDao().clear();
            return null;
        }
    }
}
