/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.utilities;

import com.flybits.android.kernel.deserializers.ContentIdField;
import com.flybits.android.kernel.deserializers.FlybitsData;
import java.lang.reflect.Field;

class FieldHelper {
    FieldHelper() {
    }

    static Field findField(String name, Object object) throws NoSuchFieldException {
        Field annotatedField = null;
        Field nativeField = null;
        for (Field f : object.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            FlybitsData a = f.getAnnotation(FlybitsData.class);
            if (a != null && a.name().equals(name)) {
                annotatedField = f;
                break;
            }
            if (!f.getName().equals(name)) continue;
            nativeField = f;
        }
        if (annotatedField != null) {
            return annotatedField;
        }
        if (nativeField != null) {
            return nativeField;
        }
        throw new NoSuchFieldException(String.format("No field matching name: %s found.", name));
    }

    static boolean isContentIdField(Field f) {
        return f.getAnnotation(ContentIdField.class) != null;
    }

    static String getFieldName(Field f) {
        FlybitsData annotation = f.getAnnotation(FlybitsData.class);
        return annotation == null ? f.getName() : annotation.name();
    }

    static boolean checkIfPrimitiveType(Class type) {
        return FieldHelper.isString(type) || FieldHelper.isBoolean(type) || FieldHelper.isFloat(type) || FieldHelper.isDouble(type) || FieldHelper.isInteger(type) || FieldHelper.isLong(type);
    }

    static boolean isString(Class type) {
        return type.getName().equals("java.lang.String");
    }

    static boolean isBoolean(Class type) {
        return type.getName().equals("java.lang.Boolean") || type.getName().equals("boolean");
    }

    static boolean isFloat(Class type) {
        return type.getName().equals("java.lang.Float") || type.getName().equals("float");
    }

    static boolean isDouble(Class type) {
        return type.getName().equals("java.lang.Double") || type.getName().equals("double");
    }

    static boolean isInteger(Class type) {
        return type.getName().equals("java.lang.Integer") || type.getName().equals("int");
    }

    static boolean isLong(Class type) {
        return type.getName().equals("java.lang.Long") || type.getName().equals("long");
    }
}

