/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;
import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.android.kernel.workers.FavouritesSyncWorker;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.models.User;
import java.util.concurrent.TimeUnit;

public class KernelScope
extends FlybitsScope {
    private static final String WORKER_NAME_CONTENT_FAVS = "Get_Content_Favs";
    public static final String ROOT = "/kernel";
    public static KernelScope SCOPE = new KernelScope();

    private KernelScope() {
        super("Kernel");
    }

    public void onConnected(Context context, User user) {
        PeriodicWorkRequest taskGetPluginsRepeat = (PeriodicWorkRequest)((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(FavouritesSyncWorker.class, 1L, TimeUnit.DAYS).addTag(WORKER_NAME_CONTENT_FAVS)).build();
        WorkManager.getInstance().enqueueUniquePeriodicWork(WORKER_NAME_CONTENT_FAVS, ExistingPeriodicWorkPolicy.REPLACE, taskGetPluginsRepeat);
    }

    public void onDisconnected(Context context, String s) {
        WorkManager.getInstance().cancelUniqueWork(WORKER_NAME_CONTENT_FAVS);
        new ClearDatabase(context).execute(new Void[0]);
    }

    public void onAccountDestroyed(Context context, String s) {
        new ClearDatabase(context).execute(new Void[0]);
    }

    public static SharedPreferences getKernelPreferences(Context context) {
        return context.getSharedPreferences("FLYBITS_PREF_KERNEL", 0);
    }

    private class ClearDatabase
    extends AsyncTask<Void, Void, Void> {
        private Context context;

        public ClearDatabase(Context context) {
            this.context = context;
        }

        protected Void doInBackground(Void ... urls) {
            KernelDatabase.getDatabase(this.context).contentDao().clear();
            KernelDatabase.getDatabase(this.context).groupDao().clear();
            return null;
        }
    }
}

