package com.flybits.android.kernel.utilities;

import com.flybits.android.kernel.deserializers.ContentIdField;
import com.flybits.android.kernel.deserializers.FlybitsData;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

class FieldHelper {

    //Private fields will return as accessible
    static Field findField(String name, Object object) throws NoSuchFieldException{
        Field annotatedField = null;
        Field nativeField = null;

        //Look for annotation or field matching pontential name, prioritizing annotation
        for (Field f: object.getClass().getDeclaredFields()){
            f.setAccessible(true);
            Annotation a = f.getAnnotation(FlybitsData.class);
            if (a != null && ((FlybitsData) a).name().equals(name)){
                annotatedField = f;
                break;
            } else if (f.getName().equals(name)){
                nativeField = f;
            }
        }

        if (annotatedField != null){
            return annotatedField;
        }else if (nativeField != null){
            return nativeField;
        }else{
            throw new NoSuchFieldException(String.format("No field matching name: %s found.",name));
        }
    }

    static boolean isContentIdField(Field f){
        return f.getAnnotation(ContentIdField.class) != null;
    }

    static String getFieldName(Field f) {
        Annotation annotation = f.getAnnotation(FlybitsData.class);
        return annotation == null? f.getName(): ((FlybitsData) annotation).name();
    }

    static boolean checkIfPrimitiveType(Class type) {
        return isString(type) || isBoolean(type) || isFloat(type) || isDouble(type) || isInteger(type) || isLong(type);
    }

    static boolean isString(Class type){
        return type.getName().equals("java.lang.String");
    }

    static boolean isBoolean(Class type){
        return type.getName().equals("java.lang.Boolean")
                || type.getName().equals("boolean");
    }

    static boolean isFloat(Class type){
        return type.getName().equals("java.lang.Float")
                || type.getName().equals("float");
    }

    static boolean isDouble(Class type){
        return type.getName().equals("java.lang.Double")
                || type.getName().equals("double");
    }

    static boolean isInteger(Class type){
        return type.getName().equals("java.lang.Integer")
                || type.getName().equals("int");
    }

    static boolean isLong(Class type){
        return type.getName().equals("java.lang.Long") || type.getName().equals("long");
    }
}
