package com.flybits.android.kernel.deserializers;

import android.content.Context;

import com.flybits.android.kernel.models.Experience;
import com.flybits.android.kernel.models.Group;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.logging.Logger;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Iterator;

public class DeserializeGroup extends IDeserializer<Group> {

    private Context context;

    public DeserializeGroup(Context context){
        this.context        = context;
    }

    @Override
    public String toJson(Group group) {

        if (group == null)
            return "{}";

        JSONObject object = new JSONObject();

        try {
            object.put("creatorId", group.getCreatorId());
        } catch (JSONException e) {}

        JSONObject localizationObject   = new JSONObject();
        ArrayList<String> listofCodes   = new ArrayList<>();
        for (String code : group.getNameObject().getListOfSupportedLanguages()){

            try {
                if (group.getName(code) != null) {

                    listofCodes.add(code);
                    JSONObject objectLanguageCode   = new JSONObject();
                    objectLanguageCode.put("name", group.getName(code));
                    localizationObject.put(code, objectLanguageCode);

                    if (group.getDescription(code) != null) {
                        objectLanguageCode.put("description", group.getDescription(code));
                        localizationObject.put(code, objectLanguageCode);
                    }
                }
            } catch (JSONException e) {}
        }

        for (String code : group.getDescriptionObject().getListOfSupportedLanguages()){

            try {
                if (!listofCodes.contains(code) && group.getDescription(code) != null) {
                    JSONObject objectLanguageCode   = new JSONObject();
                    objectLanguageCode.put("description", group.getDescription(code));
                    localizationObject.put(code, objectLanguageCode);
                }
            } catch (JSONException e) {}
        }

        try {
            object.put("localizations", localizationObject);
        } catch (JSONException e) {}

        return object.toString();
    }

    @Override
    public Group fromJson(JSONObject jsonObject) {
        try {
            if (!jsonObject.isNull("id") && !jsonObject.isNull("tenantId") && !jsonObject.isNull("creatorId") &&
                    !jsonObject.isNull("experiences")) {

                String id = jsonObject.getString("id");
                String creatorId = jsonObject.getString("creatorId");
                JSONArray experiences = jsonObject.getJSONArray("experiences");

                long createdAt = -1, modifiedAt = -1;
                if (!jsonObject.isNull("createdAt")) {
                    createdAt = jsonObject.getLong("createdAt");
                }
                if (!jsonObject.isNull("modifiedAt")) {
                    modifiedAt = jsonObject.getLong("modifiedAt");
                }

                ArrayList<Experience> experienceList = new ArrayList<>();
                DeserializeExperience expDeserializer = new DeserializeExperience(context);

                for (int j = 0; j < experiences.length(); j++) {
                    Experience experience = expDeserializer.fromJson(experiences.getJSONObject(j).toString());
                    experienceList.add(experience);
                }

                Group group = new Group(id, creatorId, experienceList, createdAt, modifiedAt,
                        SharedElements.INSTANCE.getEnabledLanguagesAsString(context));

                if (!jsonObject.isNull("localizations")) {

                    JSONObject localizationObject = jsonObject.getJSONObject("localizations");
                    Iterator<String> languages = localizationObject.keys();

                    while (languages.hasNext()) {

                        String language = languages.next();
                        JSONObject languageObj = localizationObject.getJSONObject(language);
                        if (!languageObj.isNull("description")) {
                            group.setDescription(language, languageObj.getString("description"));
                        }

                        if (!languageObj.isNull("name")) {
                            group.setName(language, languageObj.getString("name"));
                        }
                    }
                }

                return group;
            }
            return null;
        }catch (JSONException e){
            Logger.exception("DeserializeGroup.fromJson", e);
            return null;
        }
    }

    @Override
    public Group fromJson(JSONArray jsonArray) {
        return null;
    }
}
