/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.db.dao;

import android.arch.lifecycle.LiveData;
import android.arch.paging.DataSource;
import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.Query;
import android.arch.persistence.room.Transaction;
import android.content.Context;
import com.flybits.android.kernel.models.Content;
import com.flybits.internal.db.CommonsDatabase;
import java.util.List;

@Dao
public abstract class ContentDao {
    @Query(value="SELECT * FROM content WHERE id = :id")
    public abstract Content getById(String var1);

    @Query(value="SELECT * FROM content")
    public abstract List<Content> getAll();

    @Query(value="SELECT * FROM content WHERE id IN (:ids)")
    public abstract List<Content> getByIdList(List<String> var1);

    @Query(value="SELECT * FROM content WHERE id IN (:ids) LIMIT :limit")
    public abstract List<Content> getByIdList(List<String> var1, int var2);

    @Query(value="SELECT * FROM content WHERE id IN (:ids) LIMIT :limit OFFSET :offset")
    public abstract List<Content> getByIdList(List<String> var1, int var2, int var3);

    @Query(value="SELECT * FROM content WHERE id IN (:ids) ORDER BY sequence LIMIT :limit OFFSET :offset")
    public abstract List<Content> getByIdListOrdered(List<String> var1, int var2, int var3);

    @Query(value="SELECT * FROM content WHERE templateId = :templateId")
    public abstract List<Content> getAllByTemplateId(String var1);

    @Query(value="SELECT * FROM content WHERE type = :type")
    public abstract List<Content> getByType(String var1);

    @Query(value="SELECT * FROM content WHERE type IN (:typeList)")
    public abstract List<Content> getByTypeList(List<String> var1);

    @Insert(onConflict=1)
    public abstract void insert(List<Content> var1);

    @Query(value="DELETE FROM content")
    public abstract void clear();

    @Query(value="DELETE FROM content WHERE id IN (:ids)")
    public abstract void deleteByIds(List<String> var1);

    @Query(value="SELECT * FROM content")
    public abstract LiveData<List<Content>> getLive();

    @Query(value="SELECT * FROM content WHERE id IN (:ids)")
    public abstract LiveData<List<Content>> getLiveByIdList(List<String> var1);

    @Query(value="SELECT * FROM content WHERE id = :id")
    public abstract LiveData<List<Content>> getLiveById(String var1);

    @Query(value="SELECT * FROM content WHERE templateId = :templateId")
    public abstract LiveData<List<Content>> getLiveAllByTemplateId(String var1);

    @Query(value="SELECT * FROM content WHERE type = :type")
    public abstract LiveData<List<Content>> getLiveByType(String var1);

    @Query(value="SELECT * FROM content WHERE type IN (:typeList)")
    public abstract LiveData<List<Content>> getLiveByTypeList(List<String> var1);

    @Query(value="SELECT * FROM content")
    public abstract DataSource.Factory<Integer, Content> getDataSourceContent();

    @Query(value="SELECT * FROM content WHERE id IN (:ids)")
    public abstract DataSource.Factory<Integer, Content> getDataSourceContentByIdList(List<String> var1);

    @Query(value="SELECT * FROM content WHERE id = :id")
    public abstract DataSource.Factory<Integer, Content> getDataSourceContentById(String var1);

    @Query(value="SELECT * FROM content WHERE templateId = :templateId")
    public abstract DataSource.Factory<Integer, Content> getDataSourceContentAllByTemplateId(String var1);

    @Query(value="SELECT * FROM content WHERE type = :type")
    public abstract DataSource.Factory<Integer, Content> getDataSourceContentByType(String var1);

    @Query(value="SELECT * FROM content WHERE type IN (:typeList)")
    public abstract DataSource.Factory<Integer, Content> getDataSourceContentByTypeList(List<String> var1);

    @Transaction
    public void insertAndDeleteInTransaction(List<String> deleteContentIds, List<Content> insertContent) {
        this.deleteByIds(deleteContentIds);
        this.insert(insertContent);
    }

    @Transaction
    public LiveData<List<Content>> getCached(Context context, String cacheId) {
        List cachedIds = CommonsDatabase.getDatabase((Context)context).cachingEntryDAO().getIdsByCachingKey(cacheId);
        return this.getLiveByIdList(cachedIds);
    }

    @Transaction
    public List<Content> getByCacheId(Context context, String cacheId, int limit, int offset) {
        List cachedIds = CommonsDatabase.getDatabase((Context)context).cachingEntryDAO().getIdsByCachingKey(cacheId);
        return this.getByIdListOrdered(cachedIds, limit, offset);
    }
}

