/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.db.dao;

import android.arch.lifecycle.ComputableLiveData;
import android.arch.lifecycle.LiveData;
import android.arch.paging.DataSource;
import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.arch.persistence.room.paging.LimitOffsetDataSource;
import android.arch.persistence.room.util.StringUtil;
import android.content.Context;
import android.database.Cursor;
import android.support.annotation.NonNull;
import com.flybits.android.kernel.db.converters.JsonParserConverters;
import com.flybits.android.kernel.db.converters.ListStringConverters;
import com.flybits.android.kernel.db.converters.LocalizedValueConverters;
import com.flybits.android.kernel.db.dao.ContentDao;
import com.flybits.android.kernel.models.Content;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.commons.library.models.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ContentDao_Impl
extends ContentDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfContent;
    private final SharedSQLiteStatement __preparedStmtOfClear;

    public ContentDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfContent = new EntityInsertionAdapter<Content>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `content`(`id`,`templateId`,`nameObject`,`descriptionObject`,`createdAt`,`modifiedAt`,`icon`,`dataAsJson`,`type`,`metadata`,`isFavourite`,`labels`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Content value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getTemplateId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getTemplateId());
                }
                String _tmp = LocalizedValueConverters.localizedvalueToString(value.getNameObject());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                String _tmp_1 = LocalizedValueConverters.localizedvalueToString(value.getDescriptionObject());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                stmt.bindLong(5, value.getCreatedAt());
                stmt.bindLong(6, value.getModifiedAt());
                if (value.getIcon() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getIcon());
                }
                if (value.getDataAsJson() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getDataAsJson());
                }
                if (value.getType() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getType());
                }
                String _tmp_2 = JsonParserConverters.jsonParserToString(value.getMetadata());
                if (_tmp_2 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_2);
                }
                int _tmp_3 = value.getIsFavourite() ? 1 : 0;
                stmt.bindLong(11, (long)_tmp_3);
                String _tmp_4 = ListStringConverters.localizedvalueToString(value.getLabels());
                if (_tmp_4 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_4);
                }
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM content";
                return "DELETE FROM content";
            }
        };
    }

    @Override
    public void insert(List<Content> content) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfContent.insert(content);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertAndDeleteInTransaction(List<String> deleteContentIds, List<Content> insertContent) {
        this.__db.beginTransaction();
        try {
            super.insertAndDeleteInTransaction(deleteContentIds, insertContent);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LiveData<List<Content>> getCached(Context context, String cacheId) {
        this.__db.beginTransaction();
        try {
            LiveData<List<Content>> _result = super.getCached(context, cacheId);
            this.__db.setTransactionSuccessful();
            LiveData<List<Content>> liveData = _result;
            return liveData;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Content getById(String id) {
        String _sql = "SELECT * FROM content WHERE id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content WHERE id = ?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            Content _result;
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
            int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
            int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
            int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
            int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfIsFavourite = _cursor.getColumnIndexOrThrow("isFavourite");
            int _cursorIndexOfLabels = _cursor.getColumnIndexOrThrow("labels");
            if (_cursor.moveToFirst()) {
                _result = new Content();
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                _result.setTemplateId(_tmpTemplateId);
                String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                _result.setNameObject(_tmpNameObject);
                String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                _result.setDescriptionObject(_tmpDescriptionObject);
                long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                _result.setCreatedAt(_tmpCreatedAt);
                long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                _result.setModifiedAt(_tmpModifiedAt);
                String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                _result.setIcon(_tmpIcon);
                String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                _result.setDataAsJson(_tmpDataAsJson);
                String _tmpType = _cursor.getString(_cursorIndexOfType);
                _result.setType(_tmpType);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                _result.setMetadata(_tmpMetadata);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsFavourite);
                boolean _tmpIsFavourite = _tmp_3 != 0;
                _result.setIsFavourite(_tmpIsFavourite);
                String _tmp_4 = _cursor.getString(_cursorIndexOfLabels);
                ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                _result.setLabels(_tmpLabels);
            } else {
                _result = null;
            }
            Content content = _result;
            return content;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Content> getAll() {
        String _sql = "SELECT * FROM content";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
            int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
            int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
            int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
            int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfIsFavourite = _cursor.getColumnIndexOrThrow("isFavourite");
            int _cursorIndexOfLabels = _cursor.getColumnIndexOrThrow("labels");
            ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Content _item = new Content();
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                _item.setTemplateId(_tmpTemplateId);
                String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                _item.setNameObject(_tmpNameObject);
                String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                _item.setDescriptionObject(_tmpDescriptionObject);
                long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                _item.setCreatedAt(_tmpCreatedAt);
                long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                _item.setModifiedAt(_tmpModifiedAt);
                String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                _item.setIcon(_tmpIcon);
                String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                _item.setDataAsJson(_tmpDataAsJson);
                String _tmpType = _cursor.getString(_cursorIndexOfType);
                _item.setType(_tmpType);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                _item.setMetadata(_tmpMetadata);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsFavourite);
                boolean _tmpIsFavourite = _tmp_3 != 0;
                _item.setIsFavourite(_tmpIsFavourite);
                String _tmp_4 = _cursor.getString(_cursorIndexOfLabels);
                ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                _item.setLabels(_tmpLabels);
                _result.add(_item);
            }
            ArrayList<Content> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Content> getByIdList(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM content WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
            int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
            int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
            int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
            int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfIsFavourite = _cursor.getColumnIndexOrThrow("isFavourite");
            int _cursorIndexOfLabels = _cursor.getColumnIndexOrThrow("labels");
            ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Content _item_1 = new Content();
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _item_1.setId(_tmpId);
                String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                _item_1.setTemplateId(_tmpTemplateId);
                String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                _item_1.setNameObject(_tmpNameObject);
                String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                _item_1.setDescriptionObject(_tmpDescriptionObject);
                long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                _item_1.setCreatedAt(_tmpCreatedAt);
                long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                _item_1.setModifiedAt(_tmpModifiedAt);
                String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                _item_1.setIcon(_tmpIcon);
                String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                _item_1.setDataAsJson(_tmpDataAsJson);
                String _tmpType = _cursor.getString(_cursorIndexOfType);
                _item_1.setType(_tmpType);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                _item_1.setMetadata(_tmpMetadata);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsFavourite);
                boolean _tmpIsFavourite = _tmp_3 != 0;
                _item_1.setIsFavourite(_tmpIsFavourite);
                String _tmp_4 = _cursor.getString(_cursorIndexOfLabels);
                ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                _item_1.setLabels(_tmpLabels);
                _result.add(_item_1);
            }
            ArrayList<Content> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Content> getByIdList(List<String> ids, int limit) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM content WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") LIMIT ");
        _stringBuilder.append("?");
        String _sql = _stringBuilder.toString();
        int _argCount = 1 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        _statement.bindLong(_argIndex, (long)limit);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
            int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
            int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
            int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
            int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfIsFavourite = _cursor.getColumnIndexOrThrow("isFavourite");
            int _cursorIndexOfLabels = _cursor.getColumnIndexOrThrow("labels");
            ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Content _item_1 = new Content();
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _item_1.setId(_tmpId);
                String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                _item_1.setTemplateId(_tmpTemplateId);
                String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                _item_1.setNameObject(_tmpNameObject);
                String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                _item_1.setDescriptionObject(_tmpDescriptionObject);
                long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                _item_1.setCreatedAt(_tmpCreatedAt);
                long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                _item_1.setModifiedAt(_tmpModifiedAt);
                String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                _item_1.setIcon(_tmpIcon);
                String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                _item_1.setDataAsJson(_tmpDataAsJson);
                String _tmpType = _cursor.getString(_cursorIndexOfType);
                _item_1.setType(_tmpType);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                _item_1.setMetadata(_tmpMetadata);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsFavourite);
                boolean _tmpIsFavourite = _tmp_3 != 0;
                _item_1.setIsFavourite(_tmpIsFavourite);
                String _tmp_4 = _cursor.getString(_cursorIndexOfLabels);
                ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                _item_1.setLabels(_tmpLabels);
                _result.add(_item_1);
            }
            ArrayList<Content> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Content> getByIdList(List<String> ids, int limit, int offset) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM content WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") LIMIT ");
        _stringBuilder.append("?");
        _stringBuilder.append(" OFFSET ");
        _stringBuilder.append("?");
        String _sql = _stringBuilder.toString();
        int _argCount = 2 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        _statement.bindLong(_argIndex, (long)limit);
        _argIndex = 2 + _inputSize;
        _statement.bindLong(_argIndex, (long)offset);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
            int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
            int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
            int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
            int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfIsFavourite = _cursor.getColumnIndexOrThrow("isFavourite");
            int _cursorIndexOfLabels = _cursor.getColumnIndexOrThrow("labels");
            ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Content _item_1 = new Content();
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _item_1.setId(_tmpId);
                String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                _item_1.setTemplateId(_tmpTemplateId);
                String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                _item_1.setNameObject(_tmpNameObject);
                String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                _item_1.setDescriptionObject(_tmpDescriptionObject);
                long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                _item_1.setCreatedAt(_tmpCreatedAt);
                long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                _item_1.setModifiedAt(_tmpModifiedAt);
                String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                _item_1.setIcon(_tmpIcon);
                String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                _item_1.setDataAsJson(_tmpDataAsJson);
                String _tmpType = _cursor.getString(_cursorIndexOfType);
                _item_1.setType(_tmpType);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                _item_1.setMetadata(_tmpMetadata);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsFavourite);
                boolean _tmpIsFavourite = _tmp_3 != 0;
                _item_1.setIsFavourite(_tmpIsFavourite);
                String _tmp_4 = _cursor.getString(_cursorIndexOfLabels);
                ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                _item_1.setLabels(_tmpLabels);
                _result.add(_item_1);
            }
            ArrayList<Content> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Content> getAllByTemplateId(String templateId) {
        String _sql = "SELECT * FROM content WHERE templateId = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content WHERE templateId = ?", (int)1);
        int _argIndex = 1;
        if (templateId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, templateId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
            int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
            int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
            int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
            int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfIsFavourite = _cursor.getColumnIndexOrThrow("isFavourite");
            int _cursorIndexOfLabels = _cursor.getColumnIndexOrThrow("labels");
            ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Content _item = new Content();
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                _item.setTemplateId(_tmpTemplateId);
                String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                _item.setNameObject(_tmpNameObject);
                String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                _item.setDescriptionObject(_tmpDescriptionObject);
                long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                _item.setCreatedAt(_tmpCreatedAt);
                long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                _item.setModifiedAt(_tmpModifiedAt);
                String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                _item.setIcon(_tmpIcon);
                String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                _item.setDataAsJson(_tmpDataAsJson);
                String _tmpType = _cursor.getString(_cursorIndexOfType);
                _item.setType(_tmpType);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                _item.setMetadata(_tmpMetadata);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsFavourite);
                boolean _tmpIsFavourite = _tmp_3 != 0;
                _item.setIsFavourite(_tmpIsFavourite);
                String _tmp_4 = _cursor.getString(_cursorIndexOfLabels);
                ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                _item.setLabels(_tmpLabels);
                _result.add(_item);
            }
            ArrayList<Content> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Content> getByType(String type) {
        String _sql = "SELECT * FROM content WHERE type = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content WHERE type = ?", (int)1);
        int _argIndex = 1;
        if (type == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, type);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
            int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
            int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
            int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
            int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfIsFavourite = _cursor.getColumnIndexOrThrow("isFavourite");
            int _cursorIndexOfLabels = _cursor.getColumnIndexOrThrow("labels");
            ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Content _item = new Content();
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                _item.setTemplateId(_tmpTemplateId);
                String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                _item.setNameObject(_tmpNameObject);
                String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                _item.setDescriptionObject(_tmpDescriptionObject);
                long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                _item.setCreatedAt(_tmpCreatedAt);
                long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                _item.setModifiedAt(_tmpModifiedAt);
                String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                _item.setIcon(_tmpIcon);
                String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                _item.setDataAsJson(_tmpDataAsJson);
                String _tmpType = _cursor.getString(_cursorIndexOfType);
                _item.setType(_tmpType);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                _item.setMetadata(_tmpMetadata);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsFavourite);
                boolean _tmpIsFavourite = _tmp_3 != 0;
                _item.setIsFavourite(_tmpIsFavourite);
                String _tmp_4 = _cursor.getString(_cursorIndexOfLabels);
                ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                _item.setLabels(_tmpLabels);
                _result.add(_item);
            }
            ArrayList<Content> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Content> getByTypeList(List<String> typeList) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM content WHERE type IN (");
        int _inputSize = typeList.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : typeList) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
            int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
            int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
            int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
            int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfIsFavourite = _cursor.getColumnIndexOrThrow("isFavourite");
            int _cursorIndexOfLabels = _cursor.getColumnIndexOrThrow("labels");
            ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Content _item_1 = new Content();
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _item_1.setId(_tmpId);
                String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                _item_1.setTemplateId(_tmpTemplateId);
                String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                _item_1.setNameObject(_tmpNameObject);
                String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                _item_1.setDescriptionObject(_tmpDescriptionObject);
                long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                _item_1.setCreatedAt(_tmpCreatedAt);
                long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                _item_1.setModifiedAt(_tmpModifiedAt);
                String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                _item_1.setIcon(_tmpIcon);
                String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                _item_1.setDataAsJson(_tmpDataAsJson);
                String _tmpType = _cursor.getString(_cursorIndexOfType);
                _item_1.setType(_tmpType);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                _item_1.setMetadata(_tmpMetadata);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsFavourite);
                boolean _tmpIsFavourite = _tmp_3 != 0;
                _item_1.setIsFavourite(_tmpIsFavourite);
                String _tmp_4 = _cursor.getString(_cursorIndexOfLabels);
                ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                _item_1.setLabels(_tmpLabels);
                _result.add(_item_1);
            }
            ArrayList<Content> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<Content>> getLive() {
        String _sql = "SELECT * FROM content";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content", (int)0);
        return new ComputableLiveData<List<Content>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Content> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("content", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    ContentDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = ContentDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
                    int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
                    int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
                    int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
                    int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
                    int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
                    int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
                    int _cursorIndexOfIsFavourite = _cursor.getColumnIndexOrThrow("isFavourite");
                    int _cursorIndexOfLabels = _cursor.getColumnIndexOrThrow("labels");
                    ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Content _item = new Content();
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        _item.setId(_tmpId);
                        String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                        _item.setTemplateId(_tmpTemplateId);
                        String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                        LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                        _item.setNameObject(_tmpNameObject);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                        LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                        _item.setDescriptionObject(_tmpDescriptionObject);
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        _item.setCreatedAt(_tmpCreatedAt);
                        long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                        _item.setModifiedAt(_tmpModifiedAt);
                        String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                        _item.setIcon(_tmpIcon);
                        String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                        _item.setDataAsJson(_tmpDataAsJson);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        _item.setType(_tmpType);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                        JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                        _item.setMetadata(_tmpMetadata);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsFavourite);
                        boolean _tmpIsFavourite = _tmp_3 != 0;
                        _item.setIsFavourite(_tmpIsFavourite);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfLabels);
                        ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                        _item.setLabels(_tmpLabels);
                        _result.add(_item);
                    }
                    ArrayList<Content> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    @Override
    public LiveData<List<Content>> getLiveByIdList(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM content WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return new ComputableLiveData<List<Content>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Content> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("content", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    ContentDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = ContentDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
                    int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
                    int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
                    int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
                    int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
                    int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
                    int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
                    int _cursorIndexOfIsFavourite = _cursor.getColumnIndexOrThrow("isFavourite");
                    int _cursorIndexOfLabels = _cursor.getColumnIndexOrThrow("labels");
                    ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Content _item_1 = new Content();
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        _item_1.setId(_tmpId);
                        String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                        _item_1.setTemplateId(_tmpTemplateId);
                        String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                        LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                        _item_1.setNameObject(_tmpNameObject);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                        LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                        _item_1.setDescriptionObject(_tmpDescriptionObject);
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        _item_1.setCreatedAt(_tmpCreatedAt);
                        long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                        _item_1.setModifiedAt(_tmpModifiedAt);
                        String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                        _item_1.setIcon(_tmpIcon);
                        String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                        _item_1.setDataAsJson(_tmpDataAsJson);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        _item_1.setType(_tmpType);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                        JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                        _item_1.setMetadata(_tmpMetadata);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsFavourite);
                        boolean _tmpIsFavourite = _tmp_3 != 0;
                        _item_1.setIsFavourite(_tmpIsFavourite);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfLabels);
                        ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                        _item_1.setLabels(_tmpLabels);
                        _result.add(_item_1);
                    }
                    ArrayList<Content> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    @Override
    public LiveData<List<Content>> getLiveById(String id) {
        String _sql = "SELECT * FROM content WHERE id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content WHERE id = ?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        return new ComputableLiveData<List<Content>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Content> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("content", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    ContentDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = ContentDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
                    int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
                    int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
                    int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
                    int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
                    int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
                    int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
                    int _cursorIndexOfIsFavourite = _cursor.getColumnIndexOrThrow("isFavourite");
                    int _cursorIndexOfLabels = _cursor.getColumnIndexOrThrow("labels");
                    ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Content _item = new Content();
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        _item.setId(_tmpId);
                        String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                        _item.setTemplateId(_tmpTemplateId);
                        String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                        LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                        _item.setNameObject(_tmpNameObject);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                        LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                        _item.setDescriptionObject(_tmpDescriptionObject);
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        _item.setCreatedAt(_tmpCreatedAt);
                        long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                        _item.setModifiedAt(_tmpModifiedAt);
                        String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                        _item.setIcon(_tmpIcon);
                        String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                        _item.setDataAsJson(_tmpDataAsJson);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        _item.setType(_tmpType);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                        JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                        _item.setMetadata(_tmpMetadata);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsFavourite);
                        boolean _tmpIsFavourite = _tmp_3 != 0;
                        _item.setIsFavourite(_tmpIsFavourite);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfLabels);
                        ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                        _item.setLabels(_tmpLabels);
                        _result.add(_item);
                    }
                    ArrayList<Content> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    @Override
    public LiveData<List<Content>> getLiveAllByTemplateId(String templateId) {
        String _sql = "SELECT * FROM content WHERE templateId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content WHERE templateId = ?", (int)1);
        int _argIndex = 1;
        if (templateId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, templateId);
        }
        return new ComputableLiveData<List<Content>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Content> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("content", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    ContentDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = ContentDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
                    int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
                    int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
                    int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
                    int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
                    int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
                    int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
                    int _cursorIndexOfIsFavourite = _cursor.getColumnIndexOrThrow("isFavourite");
                    int _cursorIndexOfLabels = _cursor.getColumnIndexOrThrow("labels");
                    ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Content _item = new Content();
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        _item.setId(_tmpId);
                        String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                        _item.setTemplateId(_tmpTemplateId);
                        String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                        LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                        _item.setNameObject(_tmpNameObject);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                        LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                        _item.setDescriptionObject(_tmpDescriptionObject);
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        _item.setCreatedAt(_tmpCreatedAt);
                        long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                        _item.setModifiedAt(_tmpModifiedAt);
                        String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                        _item.setIcon(_tmpIcon);
                        String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                        _item.setDataAsJson(_tmpDataAsJson);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        _item.setType(_tmpType);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                        JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                        _item.setMetadata(_tmpMetadata);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsFavourite);
                        boolean _tmpIsFavourite = _tmp_3 != 0;
                        _item.setIsFavourite(_tmpIsFavourite);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfLabels);
                        ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                        _item.setLabels(_tmpLabels);
                        _result.add(_item);
                    }
                    ArrayList<Content> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    @Override
    public LiveData<List<Content>> getLiveByType(String type) {
        String _sql = "SELECT * FROM content WHERE type = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content WHERE type = ?", (int)1);
        int _argIndex = 1;
        if (type == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, type);
        }
        return new ComputableLiveData<List<Content>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Content> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("content", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    ContentDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = ContentDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
                    int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
                    int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
                    int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
                    int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
                    int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
                    int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
                    int _cursorIndexOfIsFavourite = _cursor.getColumnIndexOrThrow("isFavourite");
                    int _cursorIndexOfLabels = _cursor.getColumnIndexOrThrow("labels");
                    ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Content _item = new Content();
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        _item.setId(_tmpId);
                        String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                        _item.setTemplateId(_tmpTemplateId);
                        String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                        LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                        _item.setNameObject(_tmpNameObject);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                        LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                        _item.setDescriptionObject(_tmpDescriptionObject);
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        _item.setCreatedAt(_tmpCreatedAt);
                        long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                        _item.setModifiedAt(_tmpModifiedAt);
                        String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                        _item.setIcon(_tmpIcon);
                        String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                        _item.setDataAsJson(_tmpDataAsJson);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        _item.setType(_tmpType);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                        JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                        _item.setMetadata(_tmpMetadata);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsFavourite);
                        boolean _tmpIsFavourite = _tmp_3 != 0;
                        _item.setIsFavourite(_tmpIsFavourite);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfLabels);
                        ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                        _item.setLabels(_tmpLabels);
                        _result.add(_item);
                    }
                    ArrayList<Content> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    @Override
    public LiveData<List<Content>> getLiveByTypeList(List<String> typeList) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM content WHERE type IN (");
        int _inputSize = typeList.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : typeList) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return new ComputableLiveData<List<Content>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Content> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("content", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    ContentDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = ContentDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
                    int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
                    int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
                    int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
                    int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
                    int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
                    int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
                    int _cursorIndexOfIsFavourite = _cursor.getColumnIndexOrThrow("isFavourite");
                    int _cursorIndexOfLabels = _cursor.getColumnIndexOrThrow("labels");
                    ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Content _item_1 = new Content();
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        _item_1.setId(_tmpId);
                        String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                        _item_1.setTemplateId(_tmpTemplateId);
                        String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                        LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                        _item_1.setNameObject(_tmpNameObject);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                        LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                        _item_1.setDescriptionObject(_tmpDescriptionObject);
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        _item_1.setCreatedAt(_tmpCreatedAt);
                        long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                        _item_1.setModifiedAt(_tmpModifiedAt);
                        String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                        _item_1.setIcon(_tmpIcon);
                        String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                        _item_1.setDataAsJson(_tmpDataAsJson);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        _item_1.setType(_tmpType);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                        JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                        _item_1.setMetadata(_tmpMetadata);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsFavourite);
                        boolean _tmpIsFavourite = _tmp_3 != 0;
                        _item_1.setIsFavourite(_tmpIsFavourite);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfLabels);
                        ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                        _item_1.setLabels(_tmpLabels);
                        _result.add(_item_1);
                    }
                    ArrayList<Content> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    @Override
    public DataSource.Factory<Integer, Content> getDataSourceContent() {
        String _sql = "SELECT * FROM content";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content", (int)0);
        return new DataSource.Factory<Integer, Content>(){

            public LimitOffsetDataSource<Content> create() {
                return new LimitOffsetDataSource<Content>(ContentDao_Impl.this.__db, _statement, false, new String[]{"content"}){

                    protected List<Content> convertRows(Cursor cursor) {
                        int _cursorIndexOfId = cursor.getColumnIndexOrThrow("id");
                        int _cursorIndexOfTemplateId = cursor.getColumnIndexOrThrow("templateId");
                        int _cursorIndexOfNameObject = cursor.getColumnIndexOrThrow("nameObject");
                        int _cursorIndexOfDescriptionObject = cursor.getColumnIndexOrThrow("descriptionObject");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfModifiedAt = cursor.getColumnIndexOrThrow("modifiedAt");
                        int _cursorIndexOfIcon = cursor.getColumnIndexOrThrow("icon");
                        int _cursorIndexOfDataAsJson = cursor.getColumnIndexOrThrow("dataAsJson");
                        int _cursorIndexOfType = cursor.getColumnIndexOrThrow("type");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfIsFavourite = cursor.getColumnIndexOrThrow("isFavourite");
                        int _cursorIndexOfLabels = cursor.getColumnIndexOrThrow("labels");
                        ArrayList<Content> _res = new ArrayList<Content>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            Content _item = new Content();
                            String _tmpId = cursor.getString(_cursorIndexOfId);
                            _item.setId(_tmpId);
                            String _tmpTemplateId = cursor.getString(_cursorIndexOfTemplateId);
                            _item.setTemplateId(_tmpTemplateId);
                            String _tmp = cursor.getString(_cursorIndexOfNameObject);
                            LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                            _item.setNameObject(_tmpNameObject);
                            String _tmp_1 = cursor.getString(_cursorIndexOfDescriptionObject);
                            LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                            _item.setDescriptionObject(_tmpDescriptionObject);
                            long _tmpCreatedAt = cursor.getLong(_cursorIndexOfCreatedAt);
                            _item.setCreatedAt(_tmpCreatedAt);
                            long _tmpModifiedAt = cursor.getLong(_cursorIndexOfModifiedAt);
                            _item.setModifiedAt(_tmpModifiedAt);
                            String _tmpIcon = cursor.getString(_cursorIndexOfIcon);
                            _item.setIcon(_tmpIcon);
                            String _tmpDataAsJson = cursor.getString(_cursorIndexOfDataAsJson);
                            _item.setDataAsJson(_tmpDataAsJson);
                            String _tmpType = cursor.getString(_cursorIndexOfType);
                            _item.setType(_tmpType);
                            String _tmp_2 = cursor.getString(_cursorIndexOfMetadata);
                            JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                            _item.setMetadata(_tmpMetadata);
                            int _tmp_3 = cursor.getInt(_cursorIndexOfIsFavourite);
                            boolean _tmpIsFavourite = _tmp_3 != 0;
                            _item.setIsFavourite(_tmpIsFavourite);
                            String _tmp_4 = cursor.getString(_cursorIndexOfLabels);
                            ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                            _item.setLabels(_tmpLabels);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    public DataSource.Factory<Integer, Content> getDataSourceContentByIdList(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM content WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return new DataSource.Factory<Integer, Content>(){

            public LimitOffsetDataSource<Content> create() {
                return new LimitOffsetDataSource<Content>(ContentDao_Impl.this.__db, _statement, false, new String[]{"content"}){

                    protected List<Content> convertRows(Cursor cursor) {
                        int _cursorIndexOfId = cursor.getColumnIndexOrThrow("id");
                        int _cursorIndexOfTemplateId = cursor.getColumnIndexOrThrow("templateId");
                        int _cursorIndexOfNameObject = cursor.getColumnIndexOrThrow("nameObject");
                        int _cursorIndexOfDescriptionObject = cursor.getColumnIndexOrThrow("descriptionObject");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfModifiedAt = cursor.getColumnIndexOrThrow("modifiedAt");
                        int _cursorIndexOfIcon = cursor.getColumnIndexOrThrow("icon");
                        int _cursorIndexOfDataAsJson = cursor.getColumnIndexOrThrow("dataAsJson");
                        int _cursorIndexOfType = cursor.getColumnIndexOrThrow("type");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfIsFavourite = cursor.getColumnIndexOrThrow("isFavourite");
                        int _cursorIndexOfLabels = cursor.getColumnIndexOrThrow("labels");
                        ArrayList<Content> _res = new ArrayList<Content>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            Content _item_1 = new Content();
                            String _tmpId = cursor.getString(_cursorIndexOfId);
                            _item_1.setId(_tmpId);
                            String _tmpTemplateId = cursor.getString(_cursorIndexOfTemplateId);
                            _item_1.setTemplateId(_tmpTemplateId);
                            String _tmp = cursor.getString(_cursorIndexOfNameObject);
                            LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                            _item_1.setNameObject(_tmpNameObject);
                            String _tmp_1 = cursor.getString(_cursorIndexOfDescriptionObject);
                            LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                            _item_1.setDescriptionObject(_tmpDescriptionObject);
                            long _tmpCreatedAt = cursor.getLong(_cursorIndexOfCreatedAt);
                            _item_1.setCreatedAt(_tmpCreatedAt);
                            long _tmpModifiedAt = cursor.getLong(_cursorIndexOfModifiedAt);
                            _item_1.setModifiedAt(_tmpModifiedAt);
                            String _tmpIcon = cursor.getString(_cursorIndexOfIcon);
                            _item_1.setIcon(_tmpIcon);
                            String _tmpDataAsJson = cursor.getString(_cursorIndexOfDataAsJson);
                            _item_1.setDataAsJson(_tmpDataAsJson);
                            String _tmpType = cursor.getString(_cursorIndexOfType);
                            _item_1.setType(_tmpType);
                            String _tmp_2 = cursor.getString(_cursorIndexOfMetadata);
                            JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                            _item_1.setMetadata(_tmpMetadata);
                            int _tmp_3 = cursor.getInt(_cursorIndexOfIsFavourite);
                            boolean _tmpIsFavourite = _tmp_3 != 0;
                            _item_1.setIsFavourite(_tmpIsFavourite);
                            String _tmp_4 = cursor.getString(_cursorIndexOfLabels);
                            ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                            _item_1.setLabels(_tmpLabels);
                            _res.add(_item_1);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    public DataSource.Factory<Integer, Content> getDataSourceContentById(String id) {
        String _sql = "SELECT * FROM content WHERE id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content WHERE id = ?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        return new DataSource.Factory<Integer, Content>(){

            public LimitOffsetDataSource<Content> create() {
                return new LimitOffsetDataSource<Content>(ContentDao_Impl.this.__db, _statement, false, new String[]{"content"}){

                    protected List<Content> convertRows(Cursor cursor) {
                        int _cursorIndexOfId = cursor.getColumnIndexOrThrow("id");
                        int _cursorIndexOfTemplateId = cursor.getColumnIndexOrThrow("templateId");
                        int _cursorIndexOfNameObject = cursor.getColumnIndexOrThrow("nameObject");
                        int _cursorIndexOfDescriptionObject = cursor.getColumnIndexOrThrow("descriptionObject");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfModifiedAt = cursor.getColumnIndexOrThrow("modifiedAt");
                        int _cursorIndexOfIcon = cursor.getColumnIndexOrThrow("icon");
                        int _cursorIndexOfDataAsJson = cursor.getColumnIndexOrThrow("dataAsJson");
                        int _cursorIndexOfType = cursor.getColumnIndexOrThrow("type");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfIsFavourite = cursor.getColumnIndexOrThrow("isFavourite");
                        int _cursorIndexOfLabels = cursor.getColumnIndexOrThrow("labels");
                        ArrayList<Content> _res = new ArrayList<Content>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            Content _item = new Content();
                            String _tmpId = cursor.getString(_cursorIndexOfId);
                            _item.setId(_tmpId);
                            String _tmpTemplateId = cursor.getString(_cursorIndexOfTemplateId);
                            _item.setTemplateId(_tmpTemplateId);
                            String _tmp = cursor.getString(_cursorIndexOfNameObject);
                            LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                            _item.setNameObject(_tmpNameObject);
                            String _tmp_1 = cursor.getString(_cursorIndexOfDescriptionObject);
                            LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                            _item.setDescriptionObject(_tmpDescriptionObject);
                            long _tmpCreatedAt = cursor.getLong(_cursorIndexOfCreatedAt);
                            _item.setCreatedAt(_tmpCreatedAt);
                            long _tmpModifiedAt = cursor.getLong(_cursorIndexOfModifiedAt);
                            _item.setModifiedAt(_tmpModifiedAt);
                            String _tmpIcon = cursor.getString(_cursorIndexOfIcon);
                            _item.setIcon(_tmpIcon);
                            String _tmpDataAsJson = cursor.getString(_cursorIndexOfDataAsJson);
                            _item.setDataAsJson(_tmpDataAsJson);
                            String _tmpType = cursor.getString(_cursorIndexOfType);
                            _item.setType(_tmpType);
                            String _tmp_2 = cursor.getString(_cursorIndexOfMetadata);
                            JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                            _item.setMetadata(_tmpMetadata);
                            int _tmp_3 = cursor.getInt(_cursorIndexOfIsFavourite);
                            boolean _tmpIsFavourite = _tmp_3 != 0;
                            _item.setIsFavourite(_tmpIsFavourite);
                            String _tmp_4 = cursor.getString(_cursorIndexOfLabels);
                            ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                            _item.setLabels(_tmpLabels);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    public DataSource.Factory<Integer, Content> getDataSourceContentAllByTemplateId(String templateId) {
        String _sql = "SELECT * FROM content WHERE templateId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content WHERE templateId = ?", (int)1);
        int _argIndex = 1;
        if (templateId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, templateId);
        }
        return new DataSource.Factory<Integer, Content>(){

            public LimitOffsetDataSource<Content> create() {
                return new LimitOffsetDataSource<Content>(ContentDao_Impl.this.__db, _statement, false, new String[]{"content"}){

                    protected List<Content> convertRows(Cursor cursor) {
                        int _cursorIndexOfId = cursor.getColumnIndexOrThrow("id");
                        int _cursorIndexOfTemplateId = cursor.getColumnIndexOrThrow("templateId");
                        int _cursorIndexOfNameObject = cursor.getColumnIndexOrThrow("nameObject");
                        int _cursorIndexOfDescriptionObject = cursor.getColumnIndexOrThrow("descriptionObject");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfModifiedAt = cursor.getColumnIndexOrThrow("modifiedAt");
                        int _cursorIndexOfIcon = cursor.getColumnIndexOrThrow("icon");
                        int _cursorIndexOfDataAsJson = cursor.getColumnIndexOrThrow("dataAsJson");
                        int _cursorIndexOfType = cursor.getColumnIndexOrThrow("type");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfIsFavourite = cursor.getColumnIndexOrThrow("isFavourite");
                        int _cursorIndexOfLabels = cursor.getColumnIndexOrThrow("labels");
                        ArrayList<Content> _res = new ArrayList<Content>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            Content _item = new Content();
                            String _tmpId = cursor.getString(_cursorIndexOfId);
                            _item.setId(_tmpId);
                            String _tmpTemplateId = cursor.getString(_cursorIndexOfTemplateId);
                            _item.setTemplateId(_tmpTemplateId);
                            String _tmp = cursor.getString(_cursorIndexOfNameObject);
                            LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                            _item.setNameObject(_tmpNameObject);
                            String _tmp_1 = cursor.getString(_cursorIndexOfDescriptionObject);
                            LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                            _item.setDescriptionObject(_tmpDescriptionObject);
                            long _tmpCreatedAt = cursor.getLong(_cursorIndexOfCreatedAt);
                            _item.setCreatedAt(_tmpCreatedAt);
                            long _tmpModifiedAt = cursor.getLong(_cursorIndexOfModifiedAt);
                            _item.setModifiedAt(_tmpModifiedAt);
                            String _tmpIcon = cursor.getString(_cursorIndexOfIcon);
                            _item.setIcon(_tmpIcon);
                            String _tmpDataAsJson = cursor.getString(_cursorIndexOfDataAsJson);
                            _item.setDataAsJson(_tmpDataAsJson);
                            String _tmpType = cursor.getString(_cursorIndexOfType);
                            _item.setType(_tmpType);
                            String _tmp_2 = cursor.getString(_cursorIndexOfMetadata);
                            JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                            _item.setMetadata(_tmpMetadata);
                            int _tmp_3 = cursor.getInt(_cursorIndexOfIsFavourite);
                            boolean _tmpIsFavourite = _tmp_3 != 0;
                            _item.setIsFavourite(_tmpIsFavourite);
                            String _tmp_4 = cursor.getString(_cursorIndexOfLabels);
                            ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                            _item.setLabels(_tmpLabels);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    public DataSource.Factory<Integer, Content> getDataSourceContentByType(String type) {
        String _sql = "SELECT * FROM content WHERE type = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content WHERE type = ?", (int)1);
        int _argIndex = 1;
        if (type == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, type);
        }
        return new DataSource.Factory<Integer, Content>(){

            public LimitOffsetDataSource<Content> create() {
                return new LimitOffsetDataSource<Content>(ContentDao_Impl.this.__db, _statement, false, new String[]{"content"}){

                    protected List<Content> convertRows(Cursor cursor) {
                        int _cursorIndexOfId = cursor.getColumnIndexOrThrow("id");
                        int _cursorIndexOfTemplateId = cursor.getColumnIndexOrThrow("templateId");
                        int _cursorIndexOfNameObject = cursor.getColumnIndexOrThrow("nameObject");
                        int _cursorIndexOfDescriptionObject = cursor.getColumnIndexOrThrow("descriptionObject");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfModifiedAt = cursor.getColumnIndexOrThrow("modifiedAt");
                        int _cursorIndexOfIcon = cursor.getColumnIndexOrThrow("icon");
                        int _cursorIndexOfDataAsJson = cursor.getColumnIndexOrThrow("dataAsJson");
                        int _cursorIndexOfType = cursor.getColumnIndexOrThrow("type");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfIsFavourite = cursor.getColumnIndexOrThrow("isFavourite");
                        int _cursorIndexOfLabels = cursor.getColumnIndexOrThrow("labels");
                        ArrayList<Content> _res = new ArrayList<Content>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            Content _item = new Content();
                            String _tmpId = cursor.getString(_cursorIndexOfId);
                            _item.setId(_tmpId);
                            String _tmpTemplateId = cursor.getString(_cursorIndexOfTemplateId);
                            _item.setTemplateId(_tmpTemplateId);
                            String _tmp = cursor.getString(_cursorIndexOfNameObject);
                            LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                            _item.setNameObject(_tmpNameObject);
                            String _tmp_1 = cursor.getString(_cursorIndexOfDescriptionObject);
                            LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                            _item.setDescriptionObject(_tmpDescriptionObject);
                            long _tmpCreatedAt = cursor.getLong(_cursorIndexOfCreatedAt);
                            _item.setCreatedAt(_tmpCreatedAt);
                            long _tmpModifiedAt = cursor.getLong(_cursorIndexOfModifiedAt);
                            _item.setModifiedAt(_tmpModifiedAt);
                            String _tmpIcon = cursor.getString(_cursorIndexOfIcon);
                            _item.setIcon(_tmpIcon);
                            String _tmpDataAsJson = cursor.getString(_cursorIndexOfDataAsJson);
                            _item.setDataAsJson(_tmpDataAsJson);
                            String _tmpType = cursor.getString(_cursorIndexOfType);
                            _item.setType(_tmpType);
                            String _tmp_2 = cursor.getString(_cursorIndexOfMetadata);
                            JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                            _item.setMetadata(_tmpMetadata);
                            int _tmp_3 = cursor.getInt(_cursorIndexOfIsFavourite);
                            boolean _tmpIsFavourite = _tmp_3 != 0;
                            _item.setIsFavourite(_tmpIsFavourite);
                            String _tmp_4 = cursor.getString(_cursorIndexOfLabels);
                            ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                            _item.setLabels(_tmpLabels);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    public DataSource.Factory<Integer, Content> getDataSourceContentByTypeList(List<String> typeList) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM content WHERE type IN (");
        int _inputSize = typeList.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : typeList) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return new DataSource.Factory<Integer, Content>(){

            public LimitOffsetDataSource<Content> create() {
                return new LimitOffsetDataSource<Content>(ContentDao_Impl.this.__db, _statement, false, new String[]{"content"}){

                    protected List<Content> convertRows(Cursor cursor) {
                        int _cursorIndexOfId = cursor.getColumnIndexOrThrow("id");
                        int _cursorIndexOfTemplateId = cursor.getColumnIndexOrThrow("templateId");
                        int _cursorIndexOfNameObject = cursor.getColumnIndexOrThrow("nameObject");
                        int _cursorIndexOfDescriptionObject = cursor.getColumnIndexOrThrow("descriptionObject");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfModifiedAt = cursor.getColumnIndexOrThrow("modifiedAt");
                        int _cursorIndexOfIcon = cursor.getColumnIndexOrThrow("icon");
                        int _cursorIndexOfDataAsJson = cursor.getColumnIndexOrThrow("dataAsJson");
                        int _cursorIndexOfType = cursor.getColumnIndexOrThrow("type");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfIsFavourite = cursor.getColumnIndexOrThrow("isFavourite");
                        int _cursorIndexOfLabels = cursor.getColumnIndexOrThrow("labels");
                        ArrayList<Content> _res = new ArrayList<Content>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            Content _item_1 = new Content();
                            String _tmpId = cursor.getString(_cursorIndexOfId);
                            _item_1.setId(_tmpId);
                            String _tmpTemplateId = cursor.getString(_cursorIndexOfTemplateId);
                            _item_1.setTemplateId(_tmpTemplateId);
                            String _tmp = cursor.getString(_cursorIndexOfNameObject);
                            LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                            _item_1.setNameObject(_tmpNameObject);
                            String _tmp_1 = cursor.getString(_cursorIndexOfDescriptionObject);
                            LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                            _item_1.setDescriptionObject(_tmpDescriptionObject);
                            long _tmpCreatedAt = cursor.getLong(_cursorIndexOfCreatedAt);
                            _item_1.setCreatedAt(_tmpCreatedAt);
                            long _tmpModifiedAt = cursor.getLong(_cursorIndexOfModifiedAt);
                            _item_1.setModifiedAt(_tmpModifiedAt);
                            String _tmpIcon = cursor.getString(_cursorIndexOfIcon);
                            _item_1.setIcon(_tmpIcon);
                            String _tmpDataAsJson = cursor.getString(_cursorIndexOfDataAsJson);
                            _item_1.setDataAsJson(_tmpDataAsJson);
                            String _tmpType = cursor.getString(_cursorIndexOfType);
                            _item_1.setType(_tmpType);
                            String _tmp_2 = cursor.getString(_cursorIndexOfMetadata);
                            JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
                            _item_1.setMetadata(_tmpMetadata);
                            int _tmp_3 = cursor.getInt(_cursorIndexOfIsFavourite);
                            boolean _tmpIsFavourite = _tmp_3 != 0;
                            _item_1.setIsFavourite(_tmpIsFavourite);
                            String _tmp_4 = cursor.getString(_cursorIndexOfLabels);
                            ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
                            _item_1.setLabels(_tmpLabels);
                            _res.add(_item_1);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM content WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Content> getRaw(SupportSQLiteQuery query) {
        SupportSQLiteQuery _internalQuery = query;
        try (Cursor _cursor = this.__db.query(_internalQuery);){
            ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Content _item = this.__entityCursorConverter_comFlybitsAndroidKernelModelsContent(_cursor);
                _result.add(_item);
            }
            ArrayList<Content> arrayList = _result;
            return arrayList;
        }
    }

    @Override
    public LiveData<List<Content>> getLiveRaw(SupportSQLiteQuery query) {
        final SupportSQLiteQuery _internalQuery = query;
        return new ComputableLiveData<List<Content>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Content> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("content", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    ContentDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = ContentDao_Impl.this.__db.query(_internalQuery);){
                    ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Content _item = ContentDao_Impl.this.__entityCursorConverter_comFlybitsAndroidKernelModelsContent(_cursor);
                        _result.add(_item);
                    }
                    ArrayList<Content> arrayList = _result;
                    return arrayList;
                }
            }
        }.getLiveData();
    }

    @Override
    public DataSource.Factory<Integer, Content> getDataSourceRaw(SupportSQLiteQuery query) {
        final SupportSQLiteQuery _internalQuery = query;
        return new DataSource.Factory<Integer, Content>(){

            public LimitOffsetDataSource<Content> create() {
                return new LimitOffsetDataSource<Content>(ContentDao_Impl.this.__db, _internalQuery, false, new String[]{"content"}){

                    protected List<Content> convertRows(Cursor cursor) {
                        ArrayList<Content> _res = new ArrayList<Content>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            Content _item = ContentDao_Impl.this.__entityCursorConverter_comFlybitsAndroidKernelModelsContent(cursor);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    private Content __entityCursorConverter_comFlybitsAndroidKernelModelsContent(Cursor cursor) {
        int _cursorIndexOfId = cursor.getColumnIndex("id");
        int _cursorIndexOfTemplateId = cursor.getColumnIndex("templateId");
        int _cursorIndexOfNameObject = cursor.getColumnIndex("nameObject");
        int _cursorIndexOfDescriptionObject = cursor.getColumnIndex("descriptionObject");
        int _cursorIndexOfCreatedAt = cursor.getColumnIndex("createdAt");
        int _cursorIndexOfModifiedAt = cursor.getColumnIndex("modifiedAt");
        int _cursorIndexOfIcon = cursor.getColumnIndex("icon");
        int _cursorIndexOfDataAsJson = cursor.getColumnIndex("dataAsJson");
        int _cursorIndexOfType = cursor.getColumnIndex("type");
        int _cursorIndexOfMetadata = cursor.getColumnIndex("metadata");
        int _cursorIndexOfIsFavourite = cursor.getColumnIndex("isFavourite");
        int _cursorIndexOfLabels = cursor.getColumnIndex("labels");
        Content _entity = new Content();
        if (_cursorIndexOfId != -1) {
            String _tmpId = cursor.getString(_cursorIndexOfId);
            _entity.setId(_tmpId);
        }
        if (_cursorIndexOfTemplateId != -1) {
            String _tmpTemplateId = cursor.getString(_cursorIndexOfTemplateId);
            _entity.setTemplateId(_tmpTemplateId);
        }
        if (_cursorIndexOfNameObject != -1) {
            String _tmp = cursor.getString(_cursorIndexOfNameObject);
            LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
            _entity.setNameObject(_tmpNameObject);
        }
        if (_cursorIndexOfDescriptionObject != -1) {
            String _tmp_1 = cursor.getString(_cursorIndexOfDescriptionObject);
            LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
            _entity.setDescriptionObject(_tmpDescriptionObject);
        }
        if (_cursorIndexOfCreatedAt != -1) {
            long _tmpCreatedAt = cursor.getLong(_cursorIndexOfCreatedAt);
            _entity.setCreatedAt(_tmpCreatedAt);
        }
        if (_cursorIndexOfModifiedAt != -1) {
            long _tmpModifiedAt = cursor.getLong(_cursorIndexOfModifiedAt);
            _entity.setModifiedAt(_tmpModifiedAt);
        }
        if (_cursorIndexOfIcon != -1) {
            String _tmpIcon = cursor.getString(_cursorIndexOfIcon);
            _entity.setIcon(_tmpIcon);
        }
        if (_cursorIndexOfDataAsJson != -1) {
            String _tmpDataAsJson = cursor.getString(_cursorIndexOfDataAsJson);
            _entity.setDataAsJson(_tmpDataAsJson);
        }
        if (_cursorIndexOfType != -1) {
            String _tmpType = cursor.getString(_cursorIndexOfType);
            _entity.setType(_tmpType);
        }
        if (_cursorIndexOfMetadata != -1) {
            String _tmp_2 = cursor.getString(_cursorIndexOfMetadata);
            JsonParser _tmpMetadata = JsonParserConverters.fromString(_tmp_2);
            _entity.setMetadata(_tmpMetadata);
        }
        if (_cursorIndexOfIsFavourite != -1) {
            int _tmp_3 = cursor.getInt(_cursorIndexOfIsFavourite);
            boolean _tmpIsFavourite = _tmp_3 != 0;
            _entity.setIsFavourite(_tmpIsFavourite);
        }
        if (_cursorIndexOfLabels != -1) {
            String _tmp_4 = cursor.getString(_cursorIndexOfLabels);
            ArrayList<String> _tmpLabels = ListStringConverters.fromString(_tmp_4);
            _entity.setLabels(_tmpLabels);
        }
        return _entity;
    }
}

