package com.flybits.android.kernel.db.dao;

import android.arch.lifecycle.LiveData;
import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Delete;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.Query;
import android.arch.persistence.room.Update;

import com.flybits.android.kernel.models.Group;

import java.util.List;

import static android.arch.persistence.room.OnConflictStrategy.REPLACE;

@Dao
//TODO: Missing Comments
public interface GroupDao {

    /**
     * Get Requests
     */
    @Query("SELECT * FROM groups WHERE id = :id")
    Group getById(String id);

    @Query("SELECT * FROM groups")
    List<Group> getAll();

    @Query("SELECT * FROM groups WHERE id IN (:ids)")
    List<Group> getByCachedIds(List<String> ids);

    @Query("SELECT * FROM groups WHERE id IN (:ids) LIMIT :limit")
    List<Group> getByCachedIds(List<String> ids, int limit);

    /**
     * BASIC CRUD
     */
    @Insert(onConflict = REPLACE)
    void insert(List<Group> groups);

    @Insert(onConflict = REPLACE)
    void insert(Group groups);

    @Update
    void update(Group group);

    @Query("DELETE FROM groups")
    void clear();

    @Delete
    void delete(Group group);

    @Query("DELETE FROM groups WHERE id IN (:ids)")
    void deleteByIds(List<String> ids);

    /**
     * LIVE DATA
     */
    @Query("SELECT * FROM groups WHERE id = :id")
    LiveData<Group> getByIdLive(String id);

    @Query("SELECT * FROM groups")
    LiveData<List<Group>> getLive();

    @Query("SELECT * FROM groups WHERE id IN (:ids)")
    LiveData<List<Group>> getLiveByCacheIds(List<String> ids);
}
